/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command;

import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingCommandOutputHandler<T>
extends BaseOutputHandler
implements CommandOutputHandler<T> {
    private Command<?> command;
    private Logger log;

    public AbstractLoggingCommandOutputHandler() {
    }

    public AbstractLoggingCommandOutputHandler(@Nonnull Logger log) {
        this.log = Objects.requireNonNull(log, "log");
    }

    public void process(@Nonnull InputStream stream) throws ProcessException {
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
            if (bytes == null || bytes.length == 0) {
                this.log.trace("{}: Completed with no output", this.command);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("{}: Completed with the following output:\n{}", this.command, (Object)new String(bytes, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    @Nonnull
    public <C extends Command<T>> C setCommand(@Nonnull C command) {
        this.command = Objects.requireNonNull(command, "command");
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(command.getClass());
        }
        return command;
    }
}

