/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git;

import com.atlassian.bitbucket.content.ContentTreeNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum GitObjectType {
    BLOB("blob", ContentTreeNode.Type.FILE),
    COMMIT("commit", ContentTreeNode.Type.SUBMODULE),
    TAG("tag"),
    TREE("tree", ContentTreeNode.Type.DIRECTORY);

    private final ContentTreeNode.Type nodeType;
    private final String objectType;

    private GitObjectType(String objectType) {
        this(objectType, null);
    }

    private GitObjectType(String objectType, ContentTreeNode.Type nodeType) {
        this.objectType = objectType;
        this.nodeType = nodeType;
    }

    @Nonnull
    public static GitObjectType fromObjectType(String objectType) {
        for (GitObjectType value : GitObjectType.values()) {
            if (!objectType.equals(value.getObjectType())) continue;
            return value;
        }
        throw new IllegalArgumentException("Object type [" + objectType + "] is not a known GitObjectType");
    }

    @Nullable
    public ContentTreeNode.Type getNodeType() {
        return this.nodeType;
    }

    @Nonnull
    public String getObjectType() {
        return this.objectType;
    }
}

