/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command.diff;

import com.atlassian.bitbucket.content.DiffWhitespace;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum GitDiffWhitespace {
    SHOW(null),
    IGNORE_ALL_SPACE("--ignore-all-space");

    private final String flag;

    private GitDiffWhitespace(String flag) {
        this.flag = flag;
    }

    @Nonnull
    public static GitDiffWhitespace fromDiffWhitespace(@Nonnull DiffWhitespace value) {
        switch (Objects.requireNonNull(value, "diffWhitespace")) {
            case IGNORE_ALL: {
                return IGNORE_ALL_SPACE;
            }
            case SHOW: {
                return SHOW;
            }
        }
        throw new IllegalArgumentException(value + " is not supported by git diff");
    }

    @Nullable
    public String getFlag() {
        return this.flag;
    }

    public boolean isFlagged() {
        return this.flag != null;
    }
}

