/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.event;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
public class GitPullRequestRefsChangedEvent
extends ApplicationEvent {
    private final RefChange fromRefChange;
    private final RefChange mergeRefChange;
    private final PullRequest pullRequest;

    public GitPullRequestRefsChangedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable RefChange fromRefChange, @Nullable RefChange mergeRefChange) {
        super(source);
        this.fromRefChange = fromRefChange;
        this.mergeRefChange = mergeRefChange;
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
    }

    @Nullable
    public RefChange getFromRefChange() {
        return this.fromRefChange;
    }

    @Nullable
    public RefChange getMergeRefChange() {
        return this.mergeRefChange;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public Repository getRepository() {
        return this.pullRequest.getToRef().getRepository();
    }

    public boolean hasFromRefChanged() {
        return this.fromRefChange != null;
    }

    public boolean hasMergeRefChanged() {
        return this.mergeRefChange != null;
    }
}

