/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GitRebaseCommandParameters
extends AbstractCommandParameters {
    private final Branch branch;
    private final ApplicationUser committer;
    private final boolean commitRequired;
    private final boolean dryRun;
    private final Repository upstreamRepository;
    private final String upstream;

    private GitRebaseCommandParameters(Builder builder) {
        this.branch = builder.branch;
        this.committer = Objects.requireNonNull(builder.committer, "committer");
        this.commitRequired = builder.commitRequired;
        this.dryRun = builder.dryRun;
        this.upstreamRepository = builder.upstreamRepository;
        this.upstream = builder.upstream;
    }

    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Nonnull
    public ApplicationUser getCommitter() {
        return this.committer;
    }

    @Nonnull
    public String getUpstream() {
        return this.upstream;
    }

    @Nonnull
    public Optional<Repository> getUpstreamRepository() {
        return Optional.ofNullable(this.upstreamRepository);
    }

    public boolean isCommitRequired() {
        return this.commitRequired;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public static class Builder {
        private final Branch branch;
        private final String upstream;
        private ApplicationUser committer;
        private boolean commitRequired;
        private boolean dryRun;
        private Repository upstreamRepository;

        public Builder(@Nonnull Branch branch, @Nonnull String upstream) {
            this.branch = Objects.requireNonNull(branch, "branch");
            this.upstream = GitRebaseCommandParameters.requireNonBlank((String)upstream, (String)"upstream");
        }

        @Nonnull
        public GitRebaseCommandParameters build() {
            return new GitRebaseCommandParameters(this);
        }

        @Nonnull
        public Builder committer(@Nonnull ApplicationUser value) {
            this.committer = Objects.requireNonNull(value, "committer");
            return this;
        }

        @Nonnull
        public Builder commitRequired(boolean value) {
            this.commitRequired = value;
            return this;
        }

        @Nonnull
        public Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        @Nonnull
        public Builder upstreamRepository(@Nullable Repository value) {
            this.upstreamRepository = value;
            return this;
        }
    }
}

