/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.settingsrestriction;

import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ProjectSettingsRestrictionKeys {
    public static final SettingsKey ACCESS_KEYS = ProjectSettingsRestrictionKeys.settingsKeyFor("ssh-access-keys");
    public static final SettingsKey ACCESS_TOKENS = ProjectSettingsRestrictionKeys.settingsKeyFor("http-access-tokens");
    public static final SettingsKey AUTO_MERGE = ProjectSettingsRestrictionKeys.settingsKeyFor("auto-merge");
    public static final SettingsKey BRANCH_MODEL = ProjectSettingsRestrictionKeys.settingsKeyFor("branch-model");
    public static final SettingsKey HOOKS = ProjectSettingsRestrictionKeys.settingsKeyFor("hooks");
    public static final SettingsKey MERGE_STRATEGIES = ProjectSettingsRestrictionKeys.settingsKeyFor("merge-strategies");
    public static final SettingsKey REPOSITORY_PERMISSIONS = ProjectSettingsRestrictionKeys.settingsKeyFor("repository-permissions");
    private static final String APPLICATION_INTERNAL_NAMESPACE = "com.atlassian.bitbucket.server:internal";

    private ProjectSettingsRestrictionKeys() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    private static SettingsKey settingsKeyFor(String featureKey) {
        return new SettingsKey.Builder(APPLICATION_INTERNAL_NAMESPACE, featureKey).build();
    }

    public static SettingsKey withComponentKey(@Nonnull SettingsKey settingsKey, @Nonnull String componentKey) {
        Objects.requireNonNull(settingsKey, "settingsKey");
        Objects.requireNonNull(componentKey, "componentKey");
        return new SettingsKey.Builder(settingsKey.getNamespace(), settingsKey.getFeatureKey()).componentKey(componentKey).build();
    }
}

