/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class UserRateLimitSettingsUpdateRequest {
    private final TokenBucketSettings settings;
    private final boolean whitelisted;

    private UserRateLimitSettingsUpdateRequest(Builder builder) {
        this.settings = builder.settings;
        this.whitelisted = builder.whitelisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserRateLimitSettingsUpdateRequest)) {
            return false;
        }
        UserRateLimitSettingsUpdateRequest that = (UserRateLimitSettingsUpdateRequest)o;
        return this.whitelisted == that.whitelisted && Objects.equals(this.settings, that.settings);
    }

    @Nonnull
    public Optional<TokenBucketSettings> getSettings() {
        return Optional.ofNullable(this.settings);
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.whitelisted);
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public String toString() {
        return "UserRateLimitSettingsUpdateRequest{settings=" + this.settings + ", whitelisted=" + this.whitelisted + "}";
    }

    public static class Builder {
        private TokenBucketSettings settings;
        private boolean whitelisted;

        public UserRateLimitSettingsUpdateRequest build() {
            Preconditions.checkState((this.whitelisted || this.settings != null ? 1 : 0) != 0, (Object)"Either user is 'whitelisted' or valid rate limit settings must be provided");
            return new UserRateLimitSettingsUpdateRequest(this);
        }

        public Builder whitelisted() {
            this.settings = null;
            this.whitelisted = true;
            return this;
        }

        public Builder withSettings(@Nonnull TokenBucketSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.whitelisted = false;
            return this;
        }
    }
}

