/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning.scan;

import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretLocation;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class SecretScanResult {
    private final String commitId;
    private final CommandResult commandResult;
    private final Repository repository;
    private final List<SecretLocation> secretLocations;
    private final boolean truncated;
    private final boolean scanFailed;

    private SecretScanResult(Builder builder) {
        this.commitId = builder.commitId;
        this.commandResult = builder.commandResult;
        this.repository = builder.repository;
        this.secretLocations = ImmutableList.copyOf(builder.secretLocations);
        this.truncated = builder.truncated;
        this.scanFailed = builder.scanFailed;
    }

    public boolean failed() {
        return this.commandResult != CommandResult.SUCCEEDED || this.scanFailed;
    }

    @Nullable
    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public List<SecretLocation> getSecretLocations() {
        return this.secretLocations;
    }

    public boolean isScanFailed() {
        return this.scanFailed;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final class Builder {
        private final String commitId;
        private final Repository repository;
        private final List<SecretLocation> secretLocations = Collections.synchronizedList(new ArrayList());
        private boolean truncated;
        private CommandResult commandResult;
        private boolean scanFailed;

        public Builder(String commitId, Repository repository) {
            this.commitId = Objects.requireNonNull(commitId, "commit");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public Builder addSecretLocation(SecretLocation value) {
            this.secretLocations.add(Objects.requireNonNull(value, "secretLocation"));
            return this;
        }

        public SecretScanResult build() {
            return new SecretScanResult(this);
        }

        public Builder commandResult(CommandResult value) {
            this.commandResult = Objects.requireNonNull(value, "commandResult");
            return this;
        }

        public Builder scanFailed() {
            this.scanFailed = true;
            return this;
        }

        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }
    }
}

