/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import java.util.Objects;
import javax.annotation.Nonnull;

public class AssignPartitionRequest {
    private final String hierarchyId;
    private final boolean overrideEnabled;
    private final String scmId;

    private AssignPartitionRequest(Builder builder) {
        this.hierarchyId = builder.hierarchyId;
        this.overrideEnabled = builder.overrideEnabled;
        this.scmId = builder.scmId;
    }

    @Nonnull
    public String getHierarchyId() {
        return this.hierarchyId;
    }

    @Nonnull
    public String getScmId() {
        return this.scmId;
    }

    public boolean isOverrideEnabled() {
        return this.overrideEnabled;
    }

    public static class Builder {
        private final String hierarchyId;
        private final String scmId;
        private boolean overrideEnabled;

        public Builder(@Nonnull String scmId, @Nonnull String hierarchyId) {
            this.scmId = Objects.requireNonNull(scmId, "scmId");
            this.hierarchyId = Objects.requireNonNull(hierarchyId, "hierarchyId");
        }

        @Nonnull
        public AssignPartitionRequest build() {
            return new AssignPartitionRequest(this);
        }

        @Nonnull
        public Builder overrideEnabled(boolean value) {
            this.overrideEnabled = value;
            return this;
        }
    }
}

