/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.deployments;

import com.atlassian.bitbucket.repository.Repository;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DeleteDeploymentRequest {
    private final String commitId;
    private final long deploymentSequenceNumber;
    private final String environmentKey;
    private final String key;
    private final Repository repository;

    public DeleteDeploymentRequest(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String key, @Nonnull String environmentKey, long deploymentSequenceNumber) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.commitId = Objects.requireNonNull(StringUtils.stripToNull((String)commitId), "commitId");
        this.key = Objects.requireNonNull(StringUtils.stripToNull((String)key), "key");
        this.environmentKey = Objects.requireNonNull(StringUtils.stripToNull((String)environmentKey), "environmentKey");
        this.deploymentSequenceNumber = deploymentSequenceNumber;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public long getDeploymentSequenceNumber() {
        return this.deploymentSequenceNumber;
    }
}

