/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.codeowners;

import com.atlassian.bitbucket.repository.Repository;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CodeOwnersRequest {
    private final String sourceRefId;
    private final Repository sourceRepository;
    private final String targetRefId;
    private final Repository targetRepository;

    private CodeOwnersRequest(Builder builder) {
        this.sourceRefId = builder.sourceRefId;
        this.sourceRepository = builder.sourceRepository;
        this.targetRefId = builder.targetRefId;
        this.targetRepository = builder.targetRepository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeOwnersRequest that = (CodeOwnersRequest)o;
        return Objects.equals(this.sourceRefId, that.sourceRefId) && Objects.equals(this.sourceRepository, that.sourceRepository) && Objects.equals(this.targetRefId, that.targetRefId) && Objects.equals(this.targetRepository, that.targetRepository);
    }

    @Nonnull
    public String getSourceRefId() {
        return this.sourceRefId;
    }

    @Nonnull
    public Repository getSourceRepository() {
        return this.sourceRepository;
    }

    @Nonnull
    public String getTargetRefId() {
        return this.targetRefId;
    }

    @Nonnull
    public Repository getTargetRepository() {
        return this.targetRepository;
    }

    public int hashCode() {
        return Objects.hash(this.sourceRefId, this.sourceRepository, this.targetRefId, this.targetRepository);
    }

    public static class Builder {
        private final String sourceRefId;
        private final String targetRefId;
        private final Repository targetRepository;
        private Repository sourceRepository;

        public Builder(@Nonnull String sourceRefId, @Nonnull String targetRefId, @Nonnull Repository targetRepository) {
            this.sourceRefId = Objects.requireNonNull(sourceRefId, "sourceRefId");
            this.targetRefId = Objects.requireNonNull(targetRefId, "targetRefId");
            this.targetRepository = Objects.requireNonNull(targetRepository, "targetRepository");
            this.sourceRepository = targetRepository;
        }

        @Nonnull
        public CodeOwnersRequest build() {
            return new CodeOwnersRequest(this);
        }

        @Nonnull
        public Builder sourceRepository(@Nonnull Repository sourceRepository) {
            this.sourceRepository = Objects.requireNonNull(sourceRepository, "sourceRepository");
            return this;
        }
    }
}

