/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.policy;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.policy.DmzPolicyService;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Objects;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.repo-delete-policy.changed")
@TransactionAware
public class RepositoryDeletePolicyChangedEvent
extends ApplicationEvent {
    private final boolean isNewDefault;
    private final boolean isOldDefault;
    private final Permission newPolicy;
    private final Permission oldPolicy;

    public RepositoryDeletePolicyChangedEvent(@Nonnull Object source, @Nonnull Permission oldPolicy, @Nonnull Permission newPolicy) {
        super(source);
        this.newPolicy = Objects.requireNonNull(newPolicy, "newPolicy");
        this.oldPolicy = Objects.requireNonNull(oldPolicy, "oldPolicy");
        this.isNewDefault = newPolicy == DmzPolicyService.DEFAULT_REPOSITORY_DELETE_POLICY;
        this.isOldDefault = oldPolicy == DmzPolicyService.DEFAULT_REPOSITORY_DELETE_POLICY;
    }

    public boolean getIsNewDefault() {
        return this.isNewDefault;
    }

    public boolean getIsOldDefault() {
        return this.isOldDefault;
    }

    @Nonnull
    public Permission getNewPolicy() {
        return this.newPolicy;
    }

    @Nonnull
    public Permission getOldPolicy() {
        return this.oldPolicy;
    }
}

