/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.migration;

import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class MeshMigrationRequest {
    public static final long MIN_BYTES_PER_SECOND = 131072L;
    private final long maxBytesPerSecond;
    private final RepositoriesExportRequest repositoriesRequest;

    private MeshMigrationRequest(@Nonnull Builder builder) {
        this.maxBytesPerSecond = builder.maxBytesPerSecond;
        this.repositoriesRequest = builder.repositoriesRequest;
    }

    public long getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    @Nonnull
    public RepositoriesExportRequest getRepositoriesRequest() {
        return this.repositoriesRequest;
    }

    public static class Builder {
        private long maxBytesPerSecond = Long.MAX_VALUE;
        private RepositoriesExportRequest repositoriesRequest;

        @Nonnull
        public MeshMigrationRequest build() {
            if (this.repositoriesRequest == null) {
                throw new IllegalStateException("Repository request is required");
            }
            return new MeshMigrationRequest(this);
        }

        @Nonnull
        public Builder maxBytesPerSecond(long value) {
            Preconditions.checkArgument((value > 131072L ? 1 : 0) != 0, (Object)"maxBytesPerSecond must be at least 131072");
            this.maxBytesPerSecond = value;
            return this;
        }

        @Nonnull
        public Builder repositoriesRequest(@Nonnull RepositoriesExportRequest value) {
            this.repositoriesRequest = Objects.requireNonNull(value, "repositoriesRequest");
            return this;
        }
    }
}

