/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class UserRateLimitSettingsChangeRequest {
    private final TokenBucketSettings settings;
    private final ApplicationUser user;
    private final boolean whitelisted;

    private UserRateLimitSettingsChangeRequest(Builder builder) {
        this.user = builder.user;
        this.settings = builder.settings;
        this.whitelisted = builder.whitelisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserRateLimitSettingsChangeRequest)) {
            return false;
        }
        UserRateLimitSettingsChangeRequest that = (UserRateLimitSettingsChangeRequest)o;
        return this.whitelisted == that.whitelisted && Objects.equals(this.settings, that.settings) && this.user.equals(that.user);
    }

    @Nonnull
    public Optional<TokenBucketSettings> getSettings() {
        return Optional.ofNullable(this.settings);
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.user, this.whitelisted);
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public String toString() {
        return "UserRateLimitSettingsChangeRequest{settings=" + this.settings + ", user=" + this.user + ", whitelisted=" + this.whitelisted + '}';
    }

    public static class Builder {
        private final ApplicationUser user;
        private TokenBucketSettings settings;
        private boolean whitelisted;

        public Builder(@Nonnull ApplicationUser user) {
            this.user = Objects.requireNonNull(user, "user");
        }

        public Builder(@Nonnull UserRateLimitSettings existing) {
            this.settings = existing.getSettings().orElse(null);
            this.user = existing.getUser();
            this.whitelisted = existing.isWhitelisted();
        }

        public UserRateLimitSettingsChangeRequest build() {
            Preconditions.checkState((this.whitelisted || this.settings != null ? 1 : 0) != 0, (Object)"Either user is 'whitelisted' or valid rate limit settings must be provided");
            return new UserRateLimitSettingsChangeRequest(this);
        }

        public Builder whitelisted() {
            this.settings = null;
            this.whitelisted = true;
            return this;
        }

        public Builder withSettings(@Nonnull TokenBucketSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.whitelisted = false;
            return this;
        }
    }
}

