/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.watcher;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.atlassian.stash.internal.watcher.WatcherDao;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="watcherDao")
public class HibernateWatcherDao
extends AbstractHibernateDao<Long, InternalWatcher>
implements WatcherDao {
    @Autowired
    public HibernateWatcherDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long countWatchers(@Nonnull Watchable watchable) {
        return HibernateUtils.count((Criteria)this.particularWatchable(watchable).getExecutableCriteria(this.session()));
    }

    @Override
    public InternalWatcher create(InternalWatcher entity) {
        InternalWatcher watcher = super.create(entity);
        InternalWatchable watchable = watcher.getWatchable();
        watchable.addWatcher(watcher);
        this.session().update((Object)watchable);
        return watcher;
    }

    @Override
    public void delete(InternalWatcher entity) {
        InternalWatchable watchable = entity.getWatchable();
        watchable.removeWatcher(entity);
        this.session().update((Object)watchable);
        super.delete(entity);
    }

    @Nonnull
    public Set<InternalWatcher> findByWatchable(@Nonnull Watchable watchable) {
        Criteria criteria = this.particularWatchable(watchable).getExecutableCriteria(this.session());
        return ImmutableSet.copyOf((Collection)HibernateUtils.initializeList((List)criteria.list()));
    }

    @Nullable
    public InternalWatcher findByWatchableAndUser(@Nonnull Watchable watchable, @Nonnull ApplicationUser user) {
        return (InternalWatcher)HibernateUtils.initialize((Object)((InternalWatcher)this.particularWatchableAndUser(watchable, user).getExecutableCriteria(this.session()).uniqueResult()));
    }

    @Override
    public InternalWatcher getById(Long id) {
        return (InternalWatcher)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    public InternalWatcher update(InternalWatcher entity) {
        throw new UnsupportedOperationException("Watchers are immutable and cannot be updated.");
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.desc((String)"id"));
    }

    private DetachedCriteria particularWatchable(Watchable watchable) {
        return DetachedCriteria.forClass(InternalWatcher.class).add((Criterion)Restrictions.eq((String)"watchable", (Object)watchable));
    }

    private DetachedCriteria particularWatchableAndUser(Watchable watchable, ApplicationUser user) {
        return this.particularWatchable(watchable).add((Criterion)Restrictions.eq((String)"user", (Object)InternalConverter.convertToInternalUser((ApplicationUser)user)));
    }
}

