/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.user.AbstractHibernateGrantedPermissionDao;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="grantedGlobalPermissionDao")
public class HibernateGlobalPermissionDao
extends AbstractHibernateGrantedPermissionDao<InternalGlobalPermission>
implements GlobalPermissionDao {
    @Autowired
    public HibernateGlobalPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<PermittedUser> findHighestPermissionPerUser(@Nonnull UserType userType, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Page<ApplicationUser> page = this.findUsersWithPermission(userType, filter, pageRequest, new Criterion[0]);
        if (page.getIsLastPage() && page.getSize() == 0) {
            return HibernatePageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Query query = this.createFindHighestPermissionPerUserQuery(page, null);
        return this.pairUsersWithPermissions(page, query);
    }

    @Nonnull
    public Page<ApplicationUser> findUsersWithPermission(@Nonnull UserType userType, @Nonnull PageRequest request) {
        return this.findUsersWithPermission(userType, null, request, new Criterion[0]);
    }

    @Nonnull
    public Page<PermittedGroup> findHighestPermissionPerGroup(@Nullable String filter, @Nonnull PageRequest pageRequest) {
        Query query = this.createFindHighestPermissionPerGroupQuery(filter, null);
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsWithPermission(@Nonnull PageRequest pageRequest) {
        return super.findGroupsWithPermission(pageRequest, new Criterion[0]);
    }

    public int revoke(@Nonnull InternalGlobalPermission globalPermission) {
        return this.createRevokeQuery((InternalGrantedPermission)globalPermission, null).executeUpdate();
    }
}

