/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.bitbucket.task.TaskAnchor;
import com.atlassian.bitbucket.task.TaskCount;
import com.atlassian.bitbucket.task.TaskState;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.fugue.Effect;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.task.InternalTaskCount;
import com.atlassian.stash.internal.task.InternalTaskSearchRequest;
import com.atlassian.stash.internal.task.TaskCountProjection;
import com.atlassian.stash.internal.task.TaskDao;
import com.atlassian.stash.internal.task.TaskDaoUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="taskDao")
public class HibernateTaskDao
extends AbstractHibernateDao<Long, InternalTask>
implements TaskDao {
    private static final Iterable<Order> SEARCH_ORDERS = ImmutableList.of((Object)Order.asc((String)"state"), (Object)Order.asc((String)"createdDate"));
    private final int queryDisjunctionSize;

    @Autowired
    public HibernateTaskDao(SessionFactory sessionFactory, @Value(value="${task.query.disjunction.size}") int queryDisjunctionSize) {
        super(sessionFactory);
        this.queryDisjunctionSize = queryDisjunctionSize;
    }

    @Nonnull
    public TaskCount count(@Nonnull InternalTaskSearchRequest searchRequest) {
        return this.projectionToTaskCount(this.createCountCriteria(searchRequest).list());
    }

    @Nonnull
    public <T extends InternalTaskContext> Map<T, TaskCount> countForContexts(@Nonnull Iterable<T> contexts) {
        return this.countFor(contexts, this.getTaskCountProjectionsForContexts(contexts));
    }

    private <T> Map<T, TaskCount> countFor(Iterable<T> groupBy, final Function<Iterable<T>, List<TaskCountProjection>> getProjections) {
        final ArrayList resultsList = Lists.newArrayList();
        TaskDaoUtils.executeAsBatch(groupBy, this.queryDisjunctionSize, new Effect<Iterable<T>>(){

            public void apply(Iterable<T> batch) {
                resultsList.addAll((Collection)getProjections.apply(batch));
            }
        });
        return this.countMapToTaskCounts(this.projectionsToCountMap(groupBy, resultsList));
    }

    public <T extends InternalTaskContext> void deleteForContexts(@Nonnull Iterable<T> contexts) {
        TaskDaoUtils.executeAsBatch(contexts, this.queryDisjunctionSize, new Effect<Iterable<T>>(){

            public void apply(Iterable<T> batch) {
                HibernateTaskDao.this.session().createQuery("delete from InternalTask where context in (:contexts)").setParameterList("contexts", (Collection)Lists.newArrayList(batch)).executeUpdate();
            }
        });
    }

    @Override
    @Nonnull
    public Page<InternalTask> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage(super.findAll(pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalTask> findAll(PageRequest pageRequest, Predicate<? super InternalTask> predicate) {
        return HibernateUtils.initializePage(super.findAll(pageRequest, predicate));
    }

    @Override
    public InternalTask getById(Long id) {
        return (InternalTask)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    @Nonnull
    public List<InternalTask> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList(super.getByIds(ids));
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Arrays.asList(Order.asc((String)"createdDate"), Order.asc((String)"id"));
    }

    public boolean hasTasks(@Nonnull TaskAnchor anchor) {
        return this.createDefaultCriteria().add((Criterion)Restrictions.eq((String)"anchor", (Object)anchor)).setMaxResults(1).uniqueResult() != null;
    }

    @Nonnull
    public Page<InternalTask> search(@Nonnull InternalTaskSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.createSearchFilterCriteria(searchRequest);
        for (Order o : SEARCH_ORDERS) {
            criteria.addOrder(o);
        }
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest));
    }

    @Override
    public InternalTask update(InternalTask entity) {
        return (InternalTask)HibernateUtils.initialize((Object)super.update(entity));
    }

    private Criterion createUnionRestriction(String propertyName, Collection<?> values) {
        Criterion[] restrictions = new Criterion[values.size()];
        int i = 0;
        for (Object value : values) {
            restrictions[i++] = Restrictions.eq((String)propertyName, value);
        }
        return Restrictions.or((Criterion[])restrictions);
    }

    private Criterion createContextUnionRestriction(List<? extends InternalTaskContext> contexts) {
        return this.createUnionRestriction("context", contexts);
    }

    private Criteria createCountCriteria(InternalTaskSearchRequest searchCriteria) {
        return this.createSearchFilterCriteria(searchCriteria).setProjection((Projection)this.createDefaultCountProjections()).setResultTransformer(this.createResultTransformer());
    }

    private Criteria createCountForCriteria(Criterion restriction, PropertyProjection groupBy) {
        ProjectionList projections = this.createDefaultCountProjections().add((Projection)groupBy, "groupBy");
        return this.createDefaultCriteria().setProjection((Projection)projections).setResultTransformer(this.createResultTransformer()).add(restriction);
    }

    private ProjectionList createDefaultCountProjections() {
        return Projections.projectionList().add((Projection)Projections.groupProperty((String)"state"), "state").add(Projections.rowCount(), "count");
    }

    private Criteria createDefaultCriteria() {
        return this.session().createCriteria(InternalTask.class);
    }

    private ResultTransformer createResultTransformer() {
        return Transformers.aliasToBean(TaskCountProjection.class);
    }

    private Criteria createSearchFilterCriteria(InternalTaskSearchRequest request) {
        Criteria criteria = this.createDefaultCriteria();
        criteria.add((Criterion)Restrictions.eq((String)"context", (Object)request.getContext()));
        Set anchors = request.getAnchorIds();
        if (!anchors.isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"anchor.class", (Object)TaskDaoUtils.convertToClassName(request.getAnchorType())));
            criteria.add(Restrictions.in((String)"anchor.id", (Collection)anchors));
        }
        return criteria;
    }

    private TaskCount projectionToTaskCount(List<TaskCountProjection> projections) {
        HashMap counts = Maps.newHashMapWithExpectedSize((int)projections.size());
        for (TaskCountProjection projection : projections) {
            counts.put(projection.getState(), projection.getCount());
        }
        return new InternalTaskCount((Map)counts);
    }

    private <T> Map<T, TaskCount> countMapToTaskCounts(Map<T, Map<TaskState, Long>> aggregateCounts) {
        HashMap counts = Maps.newHashMapWithExpectedSize((int)aggregateCounts.size());
        for (Map.Entry<T, Map<TaskState, Long>> e : aggregateCounts.entrySet()) {
            counts.put(e.getKey(), new InternalTaskCount(e.getValue()));
        }
        return Collections.unmodifiableMap(counts);
    }

    private List<TaskCountProjection> getTaskCountProjections(Criterion groupBy, String groupProperty) {
        return this.createCountForCriteria(groupBy, Projections.groupProperty((String)groupProperty)).list();
    }

    private <T extends InternalTaskContext> Function<Iterable<T>, List<TaskCountProjection>> getTaskCountProjectionsForContexts(final Iterable<T> contexts) {
        return new Function<Iterable<T>, List<TaskCountProjection>>(){

            public List<TaskCountProjection> apply(@Nullable Iterable<T> batch) {
                return HibernateTaskDao.this.getTaskCountProjections(HibernateTaskDao.this.createContextUnionRestriction((List)ImmutableList.copyOf((Iterable)contexts)), "context");
            }
        };
    }

    private <T> Map<T, Map<TaskState, Long>> projectionsToCountMap(Iterable<T> groupBys, Iterable<TaskCountProjection> projections) {
        Map<T, Map<TaskState, Long>> counts = this.newEmptyCountMap(groupBys);
        for (TaskCountProjection projection : projections) {
            counts.get(projection.getGroupBy()).put(projection.getState(), projection.getCount());
        }
        return counts;
    }

    private <T> Map<T, Map<TaskState, Long>> newEmptyCountMap(Iterable<T> contexts) {
        HashMap counts = Maps.newHashMap();
        for (T context : contexts) {
            counts.put(context, Maps.newHashMap());
        }
        return counts;
    }
}

