/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.DataSourceConfigurationFactory;
import com.atlassian.stash.internal.jdbc.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.UnsupportedJdbcUrlException;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSourceConfigurationFactory
implements DataSourceConfigurationFactory {
    public static final String H2_DRIVER = "org.h2.Driver";
    public static final String HSQL_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String HSQL_PASSWORD = "";
    public static final String HSQL_URL = "jdbc:hsqldb:%1$s/data/db;shutdown=true;hsqldb.tx=mvlocks";
    public static final String HSQL_USER = "SA";
    public static final String JTDS_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    public static final String JTDS_PROTOCOL = "jdbc:jtds:sqlserver";
    public static final Pattern JTDS_URL = Pattern.compile("jdbc:jtds:sqlserver://([^:;/]++)(?::([\\d]{1,5}))?(?:/([^;]++))?(?:$|([^:/].*))");
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceConfigurationFactory.class);
    private final HomeDirectoryDetails homeDirectory;

    public DefaultDataSourceConfigurationFactory(HomeDirectoryDetails homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Nonnull
    public DataSourceConfiguration create(@Nonnull String driverClassName, @Nonnull String url, @Nonnull String user, @Nonnull String password) {
        if (H2_DRIVER.equals(driverClassName)) {
            File dataDir = new File(this.homeDirectory.getSharedHome(), "data");
            if (!new File(dataDir, "db.h2.db").isFile() && new File(dataDir, "db.script").isFile()) {
                driverClassName = HSQL_DRIVER;
                password = HSQL_PASSWORD;
                url = String.format(HSQL_URL, this.homeDirectory.getSharedHomeDir());
                user = HSQL_USER;
                log.warn("Detected legacy HSQL database; using HSQL instead of H2");
            }
        } else if (JTDS_DRIVER.equals(driverClassName)) {
            log.debug("Replacing jTDS JDBC details with Microsoft equivalents: Driver = [{}], URL = [{}]", (Object)driverClassName, (Object)url);
            driverClassName = DbType.MSSQL.getDriverClassName();
            url = DefaultDataSourceConfigurationFactory.rewriteJtdsUrl(url);
            log.warn("Replaced jTDS JDBC details with Microsoft equivalents: Driver = [{}], URL = [{}]", (Object)driverClassName, (Object)url);
        }
        return new SimpleDataSourceConfiguration(driverClassName, url, user, password);
    }

    private static Map<String, String> parseJtdsParameters(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Maps.newHashMap();
        }
        String[] pieces = value.split(";");
        HashMap<String, String> parameters = new HashMap<String, String>(pieces.length);
        for (String piece : pieces) {
            if (StringUtils.isBlank((CharSequence)piece)) continue;
            String[] keyValue = piece.split("=");
            parameters.put(keyValue[0], keyValue[1]);
        }
        return parameters;
    }

    private static int parseJtdsPort(String value) {
        int port = value == null ? (Integer)DbType.MSSQL.getDefaultPort().get() : Integer.parseInt(value);
        return port;
    }

    private static String rewriteJtdsUrl(String url) {
        Matcher matcher = JTDS_URL.matcher(url);
        if (matcher.matches()) {
            Map<String, String> parameters = DefaultDataSourceConfigurationFactory.parseJtdsParameters(matcher.group(4));
            String databaseName = matcher.group(3);
            if (databaseName == null) {
                databaseName = parameters.remove("databaseName");
            }
            if (databaseName != null && parameters.isEmpty()) {
                int port = DefaultDataSourceConfigurationFactory.parseJtdsPort(matcher.group(2));
                return DbType.MSSQL.generateUrl(matcher.group(1), databaseName, port);
            }
        }
        log.error("JDBC URL {} was not generated by {} and cannot be updated automatically", (Object)url, (Object)Product.NAME);
        throw new UnsupportedJdbcUrlException("The configured JDBC URL is no longer supported");
    }
}

