/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.idx.CommitIndexer;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.idx.IndexerStateDao;
import com.atlassian.stash.internal.idx.InternalIndexerState;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="indexerStateDao")
public class HibernateIndexerStateDao
extends AbstractHibernateDao<InternalIndexerState.PK, InternalIndexerState>
implements IndexerStateDao {
    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"indexerId"));
    }

    @Autowired
    public HibernateIndexerStateDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public Long getOldestLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull Iterable<CommitIndexer> indexers) {
        Query query;
        Object[] result;
        Set<String> indexerIds = this.extractIds(indexers);
        if (!indexerIds.isEmpty() && (result = (Object[])(query = this.session().createQuery("select count(indexerId), min(lastRun) from InternalIndexerState WHERE indexerId in (:ids) AND repository.id = :repo_id").setParameterList("ids", indexerIds).setParameter("repo_id", (Object)repository.getId())).uniqueResult()) != null) {
            Number count = (Number)result[0];
            Long lastRun = (Long)result[1];
            if (indexerIds.size() <= count.intValue()) {
                return lastRun;
            }
        }
        return null;
    }

    public Long getLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull CommitIndexer indexer) {
        InternalIndexerState state = (InternalIndexerState)this.getById(new InternalIndexerState.PK(indexer.getId(), repository.getId()));
        return state == null ? null : state.getLastRun();
    }

    @Nonnull
    public Set<Long> getReferencedLastRunTimestamps(@Nonnull InternalRepository repository) {
        Query query = this.session().createQuery("select distinct lastRun from InternalIndexerState where repository.id = :repoId").setParameter("repoId", (Object)repository.getId());
        return ImmutableSet.copyOf((Collection)query.list());
    }

    public void setLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull CommitIndexer indexer, long timestamp) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)indexer, (Object)"indexer");
        Preconditions.checkNotNull((Object)indexer.getId(), (Object)"indexer.id");
        InternalIndexerState state = new InternalIndexerState(indexer.getId(), repository, Long.valueOf(timestamp));
        this.update(state);
    }

    public void setLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull Iterable<CommitIndexer> indexers, long timestamp) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(indexers, (Object)"indexers");
        for (CommitIndexer indexer : indexers) {
            this.setLastRunTimestamp(repository, indexer, timestamp);
        }
    }

    private Set<String> extractIds(Iterable<CommitIndexer> indexers) {
        HashSet indexerIds = Sets.newHashSet();
        for (CommitIndexer indexer : indexers) {
            indexerIds.add(indexer.getId());
        }
        return indexerIds;
    }
}

