/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import java.io.Serializable;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class NoEmptyStringsInterceptor
extends EmptyInterceptor {
    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        NoEmptyStringsInterceptor.checkStrings(entity, id, currentState, propertyNames);
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        NoEmptyStringsInterceptor.checkStrings(entity, id, state, propertyNames);
        return false;
    }

    private static void checkStrings(Object entity, Serializable id, Object[] state, String[] propertyNames) {
        StringBuilder errors = null;
        String packageName = entity.getClass().getPackage().getName();
        if (packageName.startsWith("com.atlassian.stash") || packageName.startsWith("com.atlassian.bitbucket")) {
            for (int i = 0; i < state.length; ++i) {
                if (!"".equals(state[i])) continue;
                if (errors == null) {
                    errors = new StringBuilder().append(entity.getClass().getName()).append(" with id '").append(id).append("' has empty string properties: [");
                } else {
                    errors.append(", ");
                }
                errors.append(propertyNames[i]);
            }
        }
        if (errors != null) {
            errors.append("]");
            throw new CallbackException(errors.toString());
        }
    }
}

