/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

public class HibernateMembershipDao
extends MembershipDAOHibernate
implements MembershipDao,
InternalMembershipDao {
    public <T> List<T> search(long directoryId, MembershipQuery<T> query) {
        Query hibernateQuery = this.createHibernateSearchQuery(directoryId, query);
        hibernateQuery.setCacheable(true);
        hibernateQuery.setCacheRegion("query.groupMemberships");
        List results = HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
        for (Object item : results) {
            if (!(item instanceof InternalMembership)) continue;
            HibernateMembershipDao.initialize((InternalMembership)InternalMembership.class.cast(item));
        }
        return results;
    }

    public List<InternalMembership> findAll(Collection<Directory> directories) {
        return HibernateMembershipDao.initialize(super.findAll(directories));
    }

    public List<InternalMembership> findAllLocal(Collection<Directory> directories) {
        return HibernateMembershipDao.initialize(super.findAllLocal(directories));
    }

    public Object load(long ID) throws ObjectNotFoundException {
        return HibernateMembershipDao.initialize((InternalMembership)InternalMembership.class.cast(super.load(ID)));
    }

    public Object loadReference(long id) {
        return HibernateMembershipDao.initialize((InternalMembership)InternalMembership.class.cast(super.loadReference(id)));
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        super.setHqlQueryTranslater(hqlQueryTranslater);
    }

    static InternalMembership initialize(InternalMembership membership) {
        if (membership != null) {
            HibernateDirectoryDao.initialize((DirectoryImpl)DirectoryImpl.class.cast(membership.getDirectory()));
        }
        return membership;
    }

    static List<InternalMembership> initialize(List<InternalMembership> memberships) {
        for (InternalMembership membership : memberships) {
            HibernateMembershipDao.initialize(membership);
        }
        return memberships;
    }
}

