/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.DiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.commit.CommitDiscussionCommentAnchorDao;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentAnchor;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.AbstractHibernateDiffCommentAnchorDao;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="commitDiscussionCommentAnchorDao")
public class HibernateCommitDiscussionCommentAnchorDao
extends AbstractHibernateDiffCommentAnchorDao<InternalCommitDiscussion, InternalCommitDiscussionCommentAnchor>
implements CommitDiscussionCommentAnchorDao {
    @Autowired
    public HibernateCommitDiscussionCommentAnchorDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public InternalCommitDiscussionCommentAnchor getAnchorByComment(@Nonnull InternalCommitDiscussion discussion, long commentId) {
        return (InternalCommitDiscussionCommentAnchor)this.session().createQuery("select a from InternalCommitDiscussionCommentAnchor a, InternalComment c where a.discussion.id = :discussionId and c.id = :commentId and (a.comment.id = c.id or a.comment.id = c.root.id)").setLong("commentId", commentId).setLong("discussionId", discussion.getId()).uniqueResult();
    }

    @Nonnull
    public Map<InternalChangeLocation, CommentCounts> getCountsByLocation(@Nonnull InternalCommitDiscussion discussion) {
        List results = this.session().createQuery("select path, srcPath, count(*) from InternalCommitDiscussionCommentAnchor where discussion.id = :discussionId group by path, srcPath order by path, srcPath").setLong("discussionId", discussion.getId()).list();
        if (results.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap countsByLocation = Maps.newHashMapWithExpectedSize((int)results.size());
        for (Object[] columns : results) {
            InternalChangeLocation location = new InternalChangeLocation.Builder().path((String)columns[0]).srcPath((String)columns[1]).build();
            countsByLocation.put(location, new CommentCounts(((Number)columns[2]).intValue(), 0));
        }
        return countsByLocation;
    }

    @Override
    public InternalCommitDiscussionCommentAnchor update(InternalCommitDiscussionCommentAnchor entity) {
        throw new UnsupportedOperationException("CommitDiscussionCommentAnchors are immutable and cannot be updated");
    }

    @Override
    protected Criteria createAnchorCriteria(@Nonnull InternalCommitDiscussion discussion, @Nonnull DiffCommentAnchorSearchCriteria searchCriteria) {
        String fromHash = searchCriteria.hasFromHash() ? searchCriteria.getFromHash() : discussion.getParentId();
        String toHash = searchCriteria.hasToHash() ? searchCriteria.getToHash() : discussion.getCommitId();
        Criteria criteria = this.session().createCriteria(InternalCommitDiscussionCommentAnchor.class).add((Criterion)Restrictions.eq((String)"discussion.id", (Object)discussion.getId())).add((Criterion)Restrictions.eq((String)"toHash", (Object)toHash));
        if (fromHash == null) {
            criteria.add(Restrictions.isNull((String)"fromHash"));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)"fromHash", (Object)fromHash));
        }
        return criteria;
    }
}

