/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.DefaultLiquibaseSession;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseSession;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.snapshot.DatabaseSnapshot;

class LiquibaseSessionThreadLocal
extends ThreadLocal<LiquibaseSession>
implements LiquibaseSession {
    private final Supplier<DataSource> dataSourceSupplier;

    LiquibaseSessionThreadLocal(Supplier<DataSource> dataSourceSupplier) {
        this.dataSourceSupplier = (Supplier)Preconditions.checkNotNull(dataSourceSupplier);
    }

    @Override
    protected DefaultLiquibaseSession initialValue() {
        return new DefaultLiquibaseSession((DataSource)this.dataSourceSupplier.get());
    }

    @Override
    public Database getDatabase() {
        return ((LiquibaseSession)this.get()).getDatabase();
    }

    @Override
    public DatabaseSnapshot getSnapshot() {
        return ((LiquibaseSession)this.get()).getSnapshot();
    }

    @Override
    public void resetChangeCount() {
        ((LiquibaseSession)this.get()).resetChangeCount();
    }

    @Override
    public void incrementChangeCount() {
        ((LiquibaseSession)this.get()).incrementChangeCount();
    }

    @Override
    public long getChangeCount() {
        return ((LiquibaseSession)this.get()).getChangeCount();
    }

    @Override
    public void close() {
        ((LiquibaseSession)this.get()).close();
    }

    @Override
    @Nonnull
    public TypeConverter getTypeConverter() {
        return ((LiquibaseSession)this.get()).getTypeConverter();
    }
}

