/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.fugue.Effect;
import com.atlassian.security.xml.SecureXmlParserFactory;
import com.atlassian.stash.internal.backup.DatabaseTable;
import com.atlassian.stash.internal.backup.DatabaseTableAttribute;
import com.atlassian.stash.internal.backup.liquibase.ChangeLogOutline;
import com.atlassian.stash.internal.backup.liquibase.ChangeSetReader;
import com.atlassian.stash.internal.backup.liquibase.ChangeSetScanner;
import com.atlassian.stash.internal.backup.liquibase.DatabaseUpdater;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseBackupMonitor;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseConstants;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseMigrationDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseRestoreMonitor;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseXmlWriter;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseXmlWriterFactory;
import com.atlassian.stash.internal.backup.liquibase.WriteXmlForRowEffect;
import com.atlassian.stash.internal.backup.liquibase.processors.ChangeSetProcessor;
import com.atlassian.stash.internal.backup.liquibase.processors.CompositeChangeSetProcessor;
import com.atlassian.stash.internal.backup.liquibase.processors.NullFilteringChangeSetProcessor;
import com.atlassian.stash.internal.backup.liquibase.xml.DefaultXmlEncoder;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Flushables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@Component
public class DefaultLiquibaseMigrationDao
implements LiquibaseMigrationDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultLiquibaseMigrationDao.class);
    private final LiquibaseDao dao;
    private final LiquibaseXmlWriterFactory writerFactory;
    private final ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };

    @Autowired
    public DefaultLiquibaseMigrationDao(LiquibaseDao dao, LiquibaseXmlWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
        this.dao = dao;
    }

    public void backup(OutputStream stream, String author, LiquibaseBackupMonitor monitor, CancelState cancelState) throws LiquibaseDataAccessException {
        log.info("Backup process started");
        LiquibaseXmlWriter writer = this.writerFactory.create(stream, author);
        try {
            monitor.started(this.countTotalRows());
            writer.writeStartDocument(LiquibaseConstants.ENCODING, "1.0");
            writer.writeDatabaseChangeLogStartElement();
            for (String prePopulatedTableName : DatabaseTable.getTableNames((DatabaseTableAttribute)DatabaseTableAttribute.PREPOPULATED, (DatabaseTableAttribute[])new DatabaseTableAttribute[0])) {
                if (cancelState.isCanceled()) {
                    return;
                }
                writer.writeChangeSetToDeleteRowsFromTable(prePopulatedTableName);
            }
            this.writeXmlForTables(monitor, writer, DatabaseTable.getTables(), cancelState);
            writer.writeEndDocument();
            writer.flush();
            log.info("Backup process completed");
        }
        catch (XMLStreamException e) {
            throw new LiquibaseDataAccessException("An error occurred while writing to the output stream", (Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                log.error("An error occurred while closing the output stream", (Throwable)e);
            }
            this.dao.close();
        }
    }

    private long countTotalRows() {
        long totalRows = 0L;
        for (DatabaseTable table : DatabaseTable.getTables()) {
            totalRows += this.dao.countRows(table.getTableName());
        }
        return totalRows;
    }

    private void writeXmlForTables(LiquibaseBackupMonitor backupMonitor, LiquibaseXmlWriter writer, Iterable<DatabaseTable> tables, CancelState cancelState) throws XMLStreamException {
        int tableCount = Iterables.size(tables);
        long rowsWritten = 0L;
        log.info("There are {} tables to back up", (Object)tableCount);
        for (DatabaseTable table : tables) {
            if (cancelState.isCanceled()) {
                return;
            }
            String tableName = table.getTableName();
            String orderingColumn = table.getOrderingColumn();
            log.info("Backing up {} table", (Object)tableName);
            long numberOfRows = this.writeXmlForTable(this.dao, writer, tableName, orderingColumn, backupMonitor, cancelState);
            rowsWritten += numberOfRows;
            log.info("{} rows from the {} table were backed up", (Object)numberOfRows, (Object)tableName);
        }
        log.info("A total of {} rows in {} tables were backed up", (Object)rowsWritten, (Object)tableCount);
    }

    private long writeXmlForTable(LiquibaseDao dao, LiquibaseXmlWriter writer, String tableName, String orderingColumn, LiquibaseBackupMonitor monitor, CancelState cancelState) throws XMLStreamException {
        writer.writeChangeSetStartElement(tableName);
        Iterable columnNames = dao.getColumnNames(tableName);
        long numberOfRows = dao.forEachRow(tableName, orderingColumn, cancelState, (Effect)new WriteXmlForRowEffect(writer, tableName, columnNames, monitor));
        writer.writeEndElement();
        return numberOfRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(InputStream stream, File tempDir, final LiquibaseRestoreMonitor monitor, final CancelState cancelState) {
        log.info("Restore process started");
        try {
            final File tempFile = this.createTempFile(tempDir);
            try {
                log.info("Examining backup data");
                log.debug("Saving stream contents to temporary file : {}", (Object)tempFile.getAbsolutePath());
                this.saveInputToFile(stream, tempFile);
                log.debug("Performing first pass through temporary file");
                final ChangeLogOutline changeSetMetaData = this.scan(tempFile);
                log.info("Found {} non-empty change sets to apply to the target database", (Object)changeSetMetaData.nonEmptyChangeSetCount());
                log.info("Connecting to target database");
                this.dao.withLock((Effect)new Effect<LiquibaseDao>(){

                    public void apply(LiquibaseDao dao) {
                        log.debug("Beginning second pass through temporary file");
                        ChangeSetProcessor processor = DefaultLiquibaseMigrationDao.this.createProcessor(monitor, changeSetMetaData);
                        ChangeSetReader handler = new ChangeSetReader(cancelState, processor, new DefaultXmlEncoder());
                        DefaultLiquibaseMigrationDao.this.parse(tempFile, DefaultLiquibaseMigrationDao.this.buildXmlReader(handler));
                        log.info("Restore process completed");
                    }
                });
            }
            finally {
                log.debug("Deleting temporary file");
                this.deleteFile(tempFile);
            }
        }
        finally {
            this.dao.close();
        }
    }

    private ChangeSetProcessor createProcessor(LiquibaseRestoreMonitor monitor, ChangeLogOutline changeSetMetaData) {
        DatabaseUpdater databaseUpdater = new DatabaseUpdater(this.dao, monitor, changeSetMetaData);
        boolean isPostgres = StringUtils.containsIgnoreCase((CharSequence)this.dao.getDatabaseType(), (CharSequence)"postgres");
        if (isPostgres) {
            return new CompositeChangeSetProcessor(new NullFilteringChangeSetProcessor(), databaseUpdater);
        }
        return databaseUpdater;
    }

    private ChangeLogOutline scan(File xmlFile) {
        ChangeSetScanner scanner = new ChangeSetScanner();
        this.parse(xmlFile, this.buildXmlReader(scanner));
        return new ChangeLogOutline(scanner.getChangeCounts());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(File xmlFile, XMLReader xmlReader) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setEncoding(LiquibaseConstants.ENCODING);
            xmlReader.parse(inputSource);
        }
        catch (FileNotFoundException e) {
            try {
                throw new LiquibaseDataAccessException("Failed to open backup file in order to parse its contents", (Throwable)e);
                catch (IOException e2) {
                    throw new LiquibaseDataAccessException("An error occurred while parsing the backup file", (Throwable)e2);
                }
                catch (SAXException e3) {
                    throw new LiquibaseDataAccessException("SAX parsing error while parsing backup file", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(inputStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((InputStream)inputStream);
    }

    private File createTempFile(File directory) {
        try {
            return File.createTempFile("stash_", ".xml", directory);
        }
        catch (IOException e) {
            throw new LiquibaseDataAccessException("Failed to create a temporary file to hold the change log", (Throwable)e);
        }
    }

    private void deleteFile(File file) {
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
    }

    private void saveInputToFile(InputStream inputStream, File destination) {
        try (FileOutputStream to = new FileOutputStream(destination);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)to);
            Flushables.flushQuietly((Flushable)to);
        }
        catch (IOException e) {
            throw new LiquibaseDataAccessException("Failed to save the contents of the input stream to a temporary file", (Throwable)e);
        }
    }

    private XMLReader buildXmlReader(ContentHandler handler) {
        try {
            XMLReader xmlReader = SecureXmlParserFactory.newNamespaceAwareXmlReader();
            xmlReader.setErrorHandler(this.errorHandler);
            xmlReader.setContentHandler(handler);
            xmlReader.setEntityResolver(SecureXmlParserFactory.emptyEntityResolver());
            xmlReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            return xmlReader;
        }
        catch (SAXNotRecognizedException e) {
            throw new LiquibaseDataAccessException("Could not associate the XML schema language with the backup file", (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new LiquibaseDataAccessException("Could not configure the XML schema language for parsing the backup file", (Throwable)e);
        }
    }
}

