/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.activity;

import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.activity.ActivityLock;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.hibernate.SessionFactory;

public class MySqlActivityLock
implements ActivityLock {
    private final Lock createLock;
    private final Lock deleteLock;
    private final ReentrantReadWriteLock lock;
    private final SessionFactory sessionFactory;

    public MySqlActivityLock(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.lock = new ReentrantReadWriteLock();
        this.createLock = this.lock.readLock();
        this.deleteLock = this.lock.writeLock();
    }

    @Override
    @Nonnull
    public LockGuard forCreate() {
        return new FlushingLockGuard(this.createLock, this.sessionFactory);
    }

    @Override
    @Nonnull
    public LockGuard forDelete() {
        return new FlushingLockGuard(this.deleteLock, this.sessionFactory);
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    private static class FlushingLockGuard
    extends LockGuard {
        private final SessionFactory sessionFactory;

        private FlushingLockGuard(Lock lock, SessionFactory sessionFactory) {
            super(lock);
            this.sessionFactory = sessionFactory;
        }

        public void close() {
            try {
                this.sessionFactory.getCurrentSession().flush();
            }
            finally {
                super.close();
            }
        }
    }
}

