/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.stash.internal.repository.InternalRepository;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestParticipantSearchCriteria {
    private final Optional<InternalRepository> fromRepository;
    private final Optional<PullRequestRole> role;
    private final Optional<InternalRepository> toRepository;

    private PullRequestParticipantSearchCriteria(Builder builder) {
        this.fromRepository = builder.fromRepository;
        this.role = builder.role;
        this.toRepository = builder.toRepository;
    }

    @Nonnull
    public Optional<InternalRepository> getFromRepository() {
        return this.fromRepository;
    }

    @Nonnull
    public Optional<PullRequestRole> getRole() {
        return this.role;
    }

    @Nonnull
    public Optional<InternalRepository> getToRepository() {
        return this.toRepository;
    }

    public static class Builder {
        private Optional<InternalRepository> fromRepository = Optional.empty();
        private Optional<PullRequestRole> role = Optional.empty();
        private Optional<InternalRepository> toRepository = Optional.empty();

        public Builder() {
        }

        public Builder(PullRequestParticipantSearchRequest searchRequest) {
            this.fromRepository = searchRequest.getFromRepository().map(InternalRepository.class::cast);
            this.role = searchRequest.getRole();
            this.toRepository = searchRequest.getToRepository().map(InternalRepository.class::cast);
        }

        @Nonnull
        public PullRequestParticipantSearchCriteria build() {
            return new PullRequestParticipantSearchCriteria(this);
        }

        @Nonnull
        public Builder fromRepository(@Nullable InternalRepository value) {
            this.fromRepository = Optional.ofNullable(value);
            return this;
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole value) {
            this.role = Optional.ofNullable(value);
            return this;
        }

        @Nonnull
        public Builder toRepository(@Nullable InternalRepository value) {
            this.toRepository = Optional.ofNullable(value);
            return this;
        }
    }
}

