/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestActivityType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestActivitySearchCriteria {
    private final Set<CommentAction> commentActions;
    private final Set<Long> commentIds;
    private final long pullRequestId;
    private final Set<Integer> types;

    private PullRequestActivitySearchCriteria(Builder builder) {
        this.commentActions = builder.commentActions.build();
        this.commentIds = builder.commentIds.build();
        this.pullRequestId = builder.pullRequestId;
        this.types = builder.types.build();
    }

    @Nullable
    public Set<CommentAction> getCommentActions() {
        return this.commentActions;
    }

    @Nullable
    public Set<Long> getCommentIds() {
        return this.commentIds;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    @Nonnull
    public Set<Integer> getTypes() {
        return this.types;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<CommentAction> commentActions = ImmutableSet.builder();
        private final ImmutableSet.Builder<Long> commentIds = ImmutableSet.builder();
        private final ImmutableSet.Builder<Integer> types = ImmutableSet.builder();
        private long pullRequestId;

        public Builder() {
        }

        public Builder(@Nonnull InternalPullRequest pullRequest, @Nonnull PullRequestActivitySearchRequest searchRequest) {
            this();
            this.commentActions(searchRequest.getCommentActions()).commentIds(searchRequest.getCommentIds()).types(this.toActivityTypes(searchRequest.getTypes())).pullRequestId(pullRequest.getGlobalId());
        }

        @Nonnull
        public PullRequestActivitySearchCriteria build() {
            return new PullRequestActivitySearchCriteria(this);
        }

        @Nonnull
        public Builder commentActions(@Nullable Iterable<CommentAction> values) {
            Builder.addIf(Objects::nonNull, this.commentActions, values);
            return this.self();
        }

        @Nonnull
        public Builder commentIds(@Nullable Iterable<Long> values) {
            Builder.addIf(Objects::nonNull, this.commentIds, values);
            return this.self();
        }

        @Nonnull
        public Builder pullRequestId(long value) {
            this.pullRequestId = value;
            return this.self();
        }

        @Nonnull
        public Builder types(@Nullable Iterable<Integer> values) {
            Builder.addIf(Objects::nonNull, this.types, values);
            return this.self();
        }

        private Builder self() {
            return this;
        }

        private Set<Integer> toActivityTypes(Set<PullRequestActivityType> types) {
            return ImmutableSet.copyOf((Collection)Collections2.transform(types, type -> {
                switch (type) {
                    case COMMENT: {
                        return 2;
                    }
                    case MERGE: {
                        return 3;
                    }
                    case RESCOPE: {
                        return 4;
                    }
                }
                throw new IllegalArgumentException("Unsupported type: " + type);
            }));
        }
    }
}

