/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestParticipantCriteria {
    private final PullRequestRole role;
    private final Set<PullRequestParticipantStatus> statuses;
    private final ApplicationUser user;

    public PullRequestParticipantCriteria(Builder builder) {
        this.statuses = ImmutableSet.copyOf((Collection)builder.statuses);
        this.role = builder.role;
        this.user = builder.user;
    }

    @Nonnull
    public Set<PullRequestParticipantStatus> getStatuses() {
        return this.statuses;
    }

    @Nullable
    public PullRequestRole getRole() {
        return this.role;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder
    extends BuilderSupport {
        private final EnumSet<PullRequestParticipantStatus> statuses;
        private final ApplicationUser user;
        private PullRequestRole role;

        public Builder(@Nonnull ApplicationUser user) {
            this.user = (ApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user");
            this.statuses = EnumSet.noneOf(PullRequestParticipantStatus.class);
        }

        @Nonnull
        public PullRequestParticipantCriteria build() {
            return new PullRequestParticipantCriteria(this);
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole value) {
            this.role = value;
            return this;
        }

        @Nonnull
        public Builder status(@Nullable PullRequestParticipantStatus value) {
            Builder.addIf(Objects::nonNull, this.statuses, (Object)value);
            return this;
        }

        @Nonnull
        public Builder statuses(@Nonnull Iterable<PullRequestParticipantStatus> values) {
            Builder.addIf(Objects::nonNull, this.statuses, values);
            return this;
        }
    }
}

