/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.annotation;

import com.atlassian.bitbucket.pull.PullRequest;
import java.util.Objects;

public class ChangedLinesCacheKey {
    private final String fromCommit;
    private final long pullRequestId;
    private final int repositoryId;

    public ChangedLinesCacheKey(PullRequest pullRequest) {
        this.repositoryId = pullRequest.getToRef().getRepository().getId();
        this.pullRequestId = pullRequest.getId();
        this.fromCommit = pullRequest.getFromRef().getLatestCommit();
    }

    public ChangedLinesCacheKey(int repositoryId, long pullRequestId, String fromCommit) {
        this.repositoryId = repositoryId;
        this.pullRequestId = pullRequestId;
        this.fromCommit = fromCommit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedLinesCacheKey other = (ChangedLinesCacheKey)o;
        return this.repositoryId == other.repositoryId && this.pullRequestId == other.pullRequestId && Objects.equals(this.fromCommit, other.fromCommit);
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        return Objects.hash(this.pullRequestId, this.repositoryId, this.fromCommit);
    }
}

