/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.codeinsights.annotation.SingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.codeinsights.annotations.created")
@TransactionAware
public class AnalyticsAnnotationsCreatedEvent
extends RepositoryEvent {
    private static final String TYPE_UNSPECIFIED = "UNSPECIFIED";
    private final Map<String, Long> countsBySeverityAndType;

    public AnalyticsAnnotationsCreatedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Collection<SingleAddInsightAnnotationRequest> annotations) {
        super(source, repository);
        this.countsBySeverityAndType = annotations.stream().collect(Collectors.groupingBy(this::getSeverityAndType, Collectors.counting()));
    }

    @Nonnull
    public Map<String, Long> getCounts() {
        return this.countsBySeverityAndType;
    }

    private String getSeverityAndType(SingleAddInsightAnnotationRequest annotation) {
        return annotation.getSeverity().name() + "." + (annotation.getType() == null ? TYPE_UNSPECIFIED : annotation.getType().name());
    }
}

