/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest.commit;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationCallback;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.codeinsights.annotation.BulkAddInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.DeleteAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotationService;
import com.atlassian.bitbucket.codeinsights.annotation.SearchAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.SetInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.SingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.report.DeleteInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.GetInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightDataType;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightReportService;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.codeinsights.report.SearchInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.SetInsightReportRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.rest.AbstractInsightResource;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestBulkAddInsightAnnotationRequest;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightAnnotationsResponse;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReport;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportData;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestSetInsightReportRequest;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestSingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Validator;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="commitId", documentation="The commit ID on which to record the annotation. This must be a full 40 character commit hash.")})
@Tag(name="Builds and Deployments", externalDocs=@ExternalDocumentation(description="How to guide", url="https://developer.atlassian.com/server/bitbucket/how-tos/code-insights/"))
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}")
public class CommitInsightResource
extends AbstractInsightResource {
    private final InsightAnnotationService insightAnnotationService;
    private final InsightReportService insightReportService;
    private final Validator validator;

    @Inject
    public CommitInsightResource(I18nService i18nService, InsightReportService insightReportService, InsightAnnotationService insightAnnotationService, Validator validator) {
        super(i18nService);
        this.insightReportService = insightReportService;
        this.insightAnnotationService = insightAnnotationService;
        this.validator = validator;
    }

    @Operation(description="Add annotations to the given report. The request should be a JSON object mapping the string \"annotations\" to an array of maps containing the annotation data, as described below. See also the example request.\n\nA few things to note:- Annotations are an extension of a report, so a report must first exist in order to post annotations.   Annotations are posted separately from the report, and can be posted in bulk using this endpoint.\n- Only the annotations that are on lines changed in the unified diff will be displayed. This means it is  likely not all annotations posted will be displayed on the pull request  It also means that if the user is viewing a side-by-side diff,  commit diff or iterative review diff they will not be able to view the annotations.\n- A report cannot have more than 1000 annotations by default, however this property is congurable at an  instance level. If the request would result in more than the maximum number of annotations being stored  then the entire request is rejected and no new annotations are stored. \n- There is no de-duplication of annotations on Bitbucket so be sure that reruns of builds will first  delete the report and annotations before creating them.\n\n# Annotation parameters\n\n|Parameter|Description|Required?|Restrictions|Type|\n|--- |--- |--- |--- |--- |\n|path|The path of the file on which this annotation should be placed. This is the path of the filerelative to the git repository. If no path is provided, then it will appear in the overview modalon all pull requests where the tip of the branch is the given commit, regardless of which files weremodified.|No||String|\n|line|The line number that the annotation should belong to. If no line number is provided, then it willdefault to 0 and in a pull request it will appear at the top of the file specified by the path field.|No|Non-negative integer|Integer|\n|message|The message to display to users|Yes|The maximum length accepted is 2000 characters, however the user interface may truncate this valuefor display purposes. We recommend that the message is short and succinct, with further detailsavailable to the user if needed on the page linked to by the the annotation link.|String|\n|severity|The severity of the annotation|Yes|One of: LOW, MEDIUM, HIGH|String|\n|link|An http or https URL representing the location of the annotation in the external tool|No||String|\n|type|The type of annotation posted|No|One of: VULNERABILITY, CODE_SMELL, BUG|String|\n|externalId|If the caller requires a link to get or modify this annotation, then an ID must be provided. It isnot used or required by Bitbucket, but only by the annotation creator for updating or deleting thisspecific annotation.|No|A string value shorter than 450 characters|String|", summary="Add Code Insights annotations")
    @Parameter(name="key", description="The key of the report to which this annotation belongs.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the request succeeded.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not the author of the report, or the author no longer has sufficient permissions (<code>REPO_READ</code>).", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit, or report does not exist.", responseCode=404, restError=true)})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestBulkAddInsightAnnotationRequest.class))}, description="The annotations to add.")
    @POST
    @Path(value="reports/{key}/annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response addAnnotations(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @PathParam(value="key") String reportKey, RestBulkAddInsightAnnotationRequest request) {
        this.validatePathParams(commitId, reportKey);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        GetInsightReportRequest getReportRequest = new GetInsightReportRequest.Builder(repositoryResolver.getRepository(), commitId, reportKey).build();
        Optional<Response> result = this.insightReportService.get(getReportRequest).map(report -> {
            this.insightAnnotationService.addAnnotations(new BulkAddInsightAnnotationRequest.Builder(report).annotationRequests((Iterable)request.getAnnotations().stream().map(this::toAnnotationRequest).collect(MoreCollectors.toImmutableList())).build());
            return ResponseFactory.noContent().build();
        });
        return result.orElse(ResponseFactory.notFound().entity((Object)this.noSuchReport(reportKey)).build());
    }

    @Operation(description="Delete a report for the given commit. Also deletes any annotations associated with this report.", summary="Delete a Code Insights report")
    @Parameter(name="key", description="The key of the report to which this annotation belongs.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The report and associated annotations were successfully deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete insight reports or was not the author (<code>REPO_READ</code> for author otherwise <code>REPO_ADMIN</code>).", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit or report does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="reports/{key}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response deleteACodeInsightsReport(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @PathParam(value="key") String key) {
        this.validatePathParams(commitId, key);
        this.insightReportService.delete(new DeleteInsightReportRequest.Builder(repositoryResolver.getRepository(), commitId, key).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Delete annotations for a given report that match the given external IDs, or all annotations if no external IDs are provided.", summary="Delete Code Insights annotations")
    @Parameters(value={@Parameter(name="key", description="The key of the report to which this annotation belongs.", in=ParameterIn.PATH), @Parameter(name="externalId", description="The external IDs for the annotations that are to be deleted. Can be specified more than once to delete by more than one external ID, or can be unspecified to delete all annotations.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The annotations were successfully deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete insight reports or was not the author (<code>REPO_READ</code> for author otherwise <code>REPO_ADMIN</code>).", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit or report does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="reports/{key}/annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response deleteAnnotations(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @PathParam(value="key") String reportKey, @QueryParam(value="externalId") Set<String> externalIds) {
        this.validatePathParams(commitId);
        this.insightAnnotationService.delete(new DeleteAnnotationRequest.Builder(repositoryResolver.getRepository(), commitId, reportKey).externalIds(externalIds).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieve the specified report.", summary="Get a Code Insights report")
    @Parameter(name="key", description="The report key.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The specified report.", representation=RestInsightReport.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions (<code>REPO_READ needed</code>) to get insight reports.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit, or report does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="reports/{key}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response getACodeInsightsReport(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @PathParam(value="key") String key) {
        this.validatePathParams(commitId, key);
        return this.insightReportService.get(new GetInsightReportRequest.Builder(repositoryResolver.getRepository(), commitId, key).build()).map(c -> ResponseFactory.ok((Object)((Object)new RestInsightReport((InsightReport)c))).build()).orElseGet(() -> ResponseFactory.notFound().entity((Object)this.noSuchReport(key)).build());
    }

    @Operation(description="Retrieve the specified report's annotations.", summary="Get Code Insights annotations for a report")
    @Parameter(name="key", description="The report key.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The specified annotations.", representation=RestInsightAnnotationsResponse.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions (<code>REPO_READ needed</code>) to get insight reports.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit, or report does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="reports/{key}/annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response getAnnotations(final @BeanParam RepositoryResolver repositoryResolver, final @PathParam(value="commitId") String commitId, final @PathParam(value="key") String key) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                SearchAnnotationRequest request = new SearchAnnotationRequest.Builder(repositoryResolver.getRepository(), commitId).reportKey(key).build();
                CommitInsightResource.this.insightAnnotationService.stream(request, (AnnotationCallback)new AbstractInsightResource.RestAnnotationCallback(writer));
            }
        }).build();
    }

    @Operation(description="Get annotations for the given commit ID, filtered by any query parameters given.", summary="Get Code Insights annotations for a commit")
    @Parameters(value={@Parameter(name="externalId", description="Return only annotations that have one of the provided external IDs. Can be specified more than once to filter by more than one external ID.", in=ParameterIn.QUERY), @Parameter(name="key", description="Return only annotations that belong to one of the provided report keys. Can be specified more than once to filter by more than one report", in=ParameterIn.QUERY), @Parameter(name="path", description="Return only annotations that appear on one of the provided paths. Can be specified more than once to filter by more than one path.", in=ParameterIn.QUERY), @Parameter(name="severity", description="Return only annotations that have one of the given severities. Can be specified more than once to filter by more than one severity. Valid severities are <code>LOW</code>, <code>MEDIUM</code> and <code>HIGH</code>.", in=ParameterIn.QUERY), @Parameter(name="type", description="Return only annotations that have one of the given types. Can be specified more than once to filter by multiple types. Valid types are <code>BUG</code>, <code>CODE_SMELL</code>, and <code>VULNERABILITY</code>.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested annotations.", representation=RestInsightAnnotationsResponse.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions (<code>REPO_READ</code>) to get insight annotations.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit, or report does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response getAnnotations(final @BeanParam RepositoryResolver repositoryResolver, final @PathParam(value="commitId") String commitId, final @QueryParam(value="externalId") List<String> externalIds, final @QueryParam(value="key") List<String> keys, final @QueryParam(value="path") List<String> paths, final @QueryParam(value="severity") List<AnnotationSeverity> severities, final @QueryParam(value="type") List<AnnotationType> type) {
        this.validatePathParams(commitId);
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                SearchAnnotationRequest request = new SearchAnnotationRequest.Builder(repositoryResolver.getRepository(), commitId).reportKeys((Collection)keys).externalIds((Collection)externalIds).severities((Iterable)severities).paths((Collection)paths).types((Iterable)type).build();
                CommitInsightResource.this.insightAnnotationService.stream(request, (AnnotationCallback)new AbstractInsightResource.RestAnnotationCallback(writer));
            }
        }).build();
    }

    @Operation(description="Retrieve all reports for the given commit.", summary="Get all Code Insights reports for a commit")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of reports", paged=true, representation=RestInsightReport.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions (<code>REPO_READ</code>) to get insight reports.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository or commit does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="reports")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response getReports(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @BeanParam PageRequestResolver pageRequestResolver) {
        this.validatePathParams(commitId);
        Page reports = this.insightReportService.search(new SearchInsightReportRequest.Builder(repositoryResolver.getRepository(), commitId).build(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(reports, RestInsightReport::new)).build();
    }

    @Operation(description="Create a new insight report, or replace the existing one if a report already exists for the given repository, commit, and report key. A request to replace an existing report will be rejected if the authenticated user was not the creator of the specified report.\n\nThe report key should be a unique string chosen by the reporter and should be unique enough not to potentially clash with report keys from other reporters. We recommend using reverse DNS namespacing or a similar standard to ensure that collision is avoided.<h1>Report parameters</h1><table summary=\"Report parameters\">    <tr>        <th>Parameter</th>        <th>Description</th>        <th>Required?</th>        <th>Restrictions</th>        <th>Type</th>    </tr>    <tr>        <td>title</td>        <td>A short string representing the name of the report</td>        <td>Yes</td>        <td>Max length: 450 characters (but we recommend that it is shorter so that the display is nicer)</td>        <td>String</td>    </tr>    <tr>        <td>details</td>        <td>             A string to describe the purpose of the report. This string may contain             escaped newlines and if it does it will display the content accordingly.        </td>        <td>No</td>        <td>Max length: 2000 characters</td>        <td>String</td>    </tr>    <tr>        <td>result</td>        <td>Indicates whether the report is in a passed or failed state</td>        <td>No</td>        <td>One of: PASS, FAIL</td>        <td>String</td>    </tr>    <tr>        <td>data</td>        <td>An array of data fields (described below) to display information on the report</td>        <td>No</td>        <td>Maximum 6 data fields</td>        <td>Array</td>    </tr>    <tr>        <td>reporter</td>        <td>A string to describe the tool or company who created the report</td>        <td>No</td>        <td>Max length: 450 characters</td>        <td>String</td>    </tr>    <tr>        <td>link</td>        <td>A URL linking to the results of the report in an external tool.</td>        <td>No</td>        <td>Must be a valid http or https URL</td>        <td>String</td>    </tr>    <tr>        <td>logoUrl</td>        <td>A URL to the report logo. If none is provided, the default insights logo will be used.</td>        <td>No</td>        <td>Must be a valid http or https URL</td>        <td>String</td>    </tr></table><h1>Data parameters</h1>The data field on the report is an array with at most 6 data fields (JSON maps) containing information that is to be displayed on the report (see the request example).<table summary=\"Data parameters\">    <tr>        <th>Parameter</th>        <th>Description</th>        <th>Type</th>    </tr>    <tr>        <td>title</td>        <td>A string describing what this data field represents</td>        <td>String</td>    </tr>    <tr>        <td>type</td>        <td>             The type of data contained in the value field. If not provided,             then the value will be detected as a boolean, number or string.             One of: BOOLEAN, DATE, DURATION, LINK, NUMBER, PERCENTAGE, TEXT        </td>        <td>String</td>    </tr>    <tr>        <td>value</td>        <td>            A value based on the type provided. Either a raw value             (string, number or boolean) or a map. See below.        </td>    </tr></table><table summary=\"Types\">    <tr>        <th>Type Field</th>        <th>Value Field Type</th>        <th>Value Field Display</th>    </tr>    <tr>        <td>None/Omitted</td>        <td>Number, String or Boolean (not an array or object)</td>        <td>Plain text</td>    </tr>    <tr>        <td>BOOLEAN</td>        <td>Boolean</td>        <td>The value will be read as a JSON boolean and displayed as 'Yes' or 'No'.</td>    </tr>    <tr>        <td>DATE</td>        <td>Number</td>        <td>             The value will be read as a JSON number in the form of a Unix timestamp              (milliseconds) and will be displayed as a relative date if the date is less             than one week ago, otherwise it will be displayed as an absolute date.        </td>    </tr>    <tr>        <td>DURATION</td>        <td>Number</td>        <td>             The value will be read as a JSON number in milliseconds and             will be displayed in a human readable duration format.        </td>    </tr>    <tr>        <td>LINK</td>        <td>Object: {\"linktext\": \"Link text here\", \"href\": \"https://link.to.annotation/in/external/tool\"}</td>        <td>             The value will be read as a JSON object containing the fields \"linktext\"             and \"href\" and will be displayed as a clickable link on the report.        </td>    </tr>    <tr>        <td>NUMBER</td>        <td>Number</td>        <td>             The value will be read as a JSON number and large numbers will             be displayed in a human readable format (e.g. 14.3k).        </td>    </tr>    <tr>        <td>PERCENTAGE</td>        <td>Number (between 0 and 100)</td>        <td>             The value will be read as a JSON number between 0 and 100              and will be displayed with a percentage sign.        </td>    </tr>    <tr>        <td>TEXT</td>        <td>String</td>        <td>The value will be read as a JSON string and will be displayed as-is</td>    </tr></table>", summary="Create a Code Insights report", externalDocs=@ExternalDocumentation(description="Tutorial adding Code Insights to your CI system", url="https://developer.atlassian.com/server/bitbucket/tutorials-and-examples/code-insights-tutorial/"))
    @Parameter(name="key", description="A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The created report.", representation=RestInsightReport.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not permitted to create an insight report or authentication failed.", responseCode=401, restError=true), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details):\n\n- The request does not contain a report title.\n- The data field contains unsupported objects.\n- The request does not contain a report key/\n- The provided commit hash is invalid, according to  the validation rules mentioned for the commitId above.\n", responseCode=400, restError=true)})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestSetInsightReportRequest.class))}, description="The request object containing the details of the report to create (see example).")
    @PUT
    @Path(value="reports/{key}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response setACodeInsightsReport(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @PathParam(value="key") String key, RestSetInsightReportRequest request) {
        this.validatePathParams(commitId, key);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        return ResponseFactory.ok((Object)((Object)new RestInsightReport(this.insightReportService.set(new SetInsightReportRequest.Builder(repositoryResolver.getRepository(), commitId, key, request.getTitle()).coverageProviderKey(request.getCoverageProviderKey()).data((List)request.getData().stream().map(this::toInsightData).collect(MoreCollectors.toImmutableList())).details(request.getDetails()).link(this.toURI(request.getLink(), "bitbucket.rest.codeinsights.error.link.url")).logoUrl(this.toURI(request.getLogoUrl(), "bitbucket.rest.codeinsights.error.logo-url.url")).result(this.toResult(request.getResult())).reporter(request.getReporter()).build())))).build();
    }

    @Operation(description="Create an annotation with the given external ID, or replace it if it already exists. A request to replace an existing annotation will be rejected if the authenticated user was not the creator of the specified report.", summary="Create or replace a Code Insights annotation")
    @Parameters(value={@Parameter(name="key", description="The key of the report to which this annotation belongs", in=ParameterIn.PATH), @Parameter(name="externalId", description="The external ID of the annotation that is to be updated or created", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="No content, indicating that the request succeeded.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not the author of the report, or the author no longer has sufficient permissions (<code>REPO_READ</code>).", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project, repository, commit, report or annotation does not exist.", responseCode=404, restError=true)})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestSingleAddInsightAnnotationRequest.class))}, description="The new annotation that is to replace the existing one.")
    @PUT
    @Path(value="reports/{key}/annotations/{externalId}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response setAnnotation(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @PathParam(value="key") String reportKey, @PathParam(value="externalId") String externalId, RestSingleAddInsightAnnotationRequest request) {
        this.validatePathParams(commitId, reportKey, externalId);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        GetInsightReportRequest getReportRequest = new GetInsightReportRequest.Builder(repositoryResolver.getRepository(), commitId, reportKey).build();
        Optional<Response> result = this.insightReportService.get(getReportRequest).map(report -> {
            this.insightAnnotationService.set(new SetInsightAnnotationRequest.Builder(report, this.toAnnotationRequest(request, externalId)).build());
            return ResponseFactory.noContent().build();
        });
        return result.orElse(ResponseFactory.notFound().entity((Object)this.noSuchReport(reportKey)).build());
    }

    private SingleAddInsightAnnotationRequest toAnnotationRequest(RestSingleAddInsightAnnotationRequest annotation) {
        return this.toAnnotationRequest(annotation, annotation.getExternalId());
    }

    private SingleAddInsightAnnotationRequest toAnnotationRequest(RestSingleAddInsightAnnotationRequest annotation, String externalId) {
        return new SingleAddInsightAnnotationRequest.Builder(annotation.getLine(), annotation.getMessage(), annotation.getPath()).externalId(externalId).link(this.toURI(annotation.getLink(), "bitbucket.rest.codeinsights.annotation.error.link.url")).severity(AnnotationSeverity.valueOf((String)annotation.getSeverity())).type(annotation.getType() == null ? null : AnnotationType.valueOf((String)annotation.getType())).build();
    }

    private InsightReportData toInsightData(RestInsightReportData restData) {
        InsightReportData.Builder builder = new InsightReportData.Builder(restData.getTitle(), restData.getValue());
        String format = restData.getType();
        if (format != null) {
            builder.type(InsightDataType.valueOf((String)format));
        }
        return builder.build();
    }

    private InsightResult toResult(String result) {
        if (result == null) {
            return null;
        }
        return InsightResult.valueOf((String)result.toUpperCase(Locale.ROOT));
    }

    private void validatePathParams(String commitId) {
        if (!ShaUtils.isHash((String)commitId)) {
            throw new BadRequestException("commitId", this.i18nService.getMessage("bitbucket.codeinsights.error.commitId", new Object[0]));
        }
    }

    private void validatePathParams(String commitId, String reportKey) {
        this.validatePathParams(commitId);
        if (StringUtils.length((CharSequence)reportKey) > 50) {
            throw new BadRequestException("key", this.i18nService.getMessage("bitbucket.rest.codeinsights.error.key.length", new Object[0]));
        }
    }

    private void validatePathParams(String commitId, String reportKey, String externalId) {
        this.validatePathParams(commitId, reportKey);
        if (StringUtils.isBlank((CharSequence)externalId)) {
            throw new BadRequestException("externalId", this.i18nService.getMessage("bitbucket.rest.codeinsights.annotation.error.update.externalid", new Object[0]));
        }
    }
}

