define('bitbucket-plugin-code-insights/internal/page/settings/code-insights-settings', ['exports', '@atlassian/aui', 'react', 'react-dom', 'bitbucket/internal/util/i18n-html', './components/merge-check-settings-table'], function (exports, _aui, _react, _reactDom, _i18nHtml, _mergeCheckSettingsTable) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _i18nHtml2 = _interopRequireDefault(_i18nHtml);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var CodeInsightsSettingsPage = function (_Component) {
        _inherits(CodeInsightsSettingsPage, _Component);

        function CodeInsightsSettingsPage() {
            _classCallCheck(this, CodeInsightsSettingsPage);

            return _possibleConstructorReturn(this, (CodeInsightsSettingsPage.__proto__ || Object.getPrototypeOf(CodeInsightsSettingsPage)).apply(this, arguments));
        }

        _createClass(CodeInsightsSettingsPage, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    settings = _props.settings,
                    inheritedSettings = _props.inheritedSettings,
                    scopeType = _props.scopeType,
                    inheritUrl = _props.inheritUrl;


                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    _react2.default.createElement(
                        'header',
                        { className: 'aui-page-header' },
                        _react2.default.createElement(
                            'div',
                            { className: 'aui-page-header-inner' },
                            _react2.default.createElement(
                                'div',
                                { className: 'aui-page-header-main' },
                                _react2.default.createElement(
                                    'div',
                                    { className: 'aui-page-header-main' },
                                    _react2.default.createElement(
                                        'h2',
                                        null,
                                        _aui.I18n.getText('bitbucket.codeinsights.mergecheck.page.title')
                                    )
                                ),
                                _react2.default.createElement(
                                    _i18nHtml2.default.p,
                                    null,
                                    _aui.I18n.getText('bitbucket.codeinsights.mergecheck.page.description', bitbucket_help_url('bitbucket.go.code.insights.learn.more'))
                                )
                            )
                        )
                    ),
                    _react2.default.createElement(_mergeCheckSettingsTable.MergeCheckSettingsTable, {
                        settings: settings,
                        inheritedSettings: inheritedSettings,
                        scopeType: scopeType,
                        inheritUrl: inheritUrl
                    })
                );
            }
        }]);

        return CodeInsightsSettingsPage;
    }(_react.Component);

    function onReady(_ref) {
        var container = _ref.container,
            repository = _ref.repository,
            project = _ref.project,
            scopeType = _ref.scopeType,
            settings = _ref.settings,
            inheritedSettings = _ref.inheritedSettings,
            inheritUrl = _ref.inheritUrl;

        _reactDom2.default.render(_react2.default.createElement(CodeInsightsSettingsPage, {
            repository: repository,
            project: project,
            scopeType: scopeType,
            settings: settings,
            inheritedSettings: inheritedSettings,
            inheritUrl: inheritUrl
        }), document.getElementById(container));
    }
});