/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightAnnotation;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightAnnotation;
import com.atlassian.bitbucket.util.UrlUtils;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class PartialAoInsightAnnotation {
    private final AoInsightAnnotation delegate;
    private URI link;
    private AnnotationSeverity severity;
    private AnnotationType type;

    public PartialAoInsightAnnotation(AoInsightAnnotation delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.delegate.getInternalExternalId());
    }

    @Nonnull
    public Optional<String> getFilePath() {
        return Optional.ofNullable(StringUtils.stripToNull((String)this.getPath()));
    }

    public long getId() {
        return this.delegate.getID();
    }

    @Nonnull
    public Optional<URI> getLink() {
        return Optional.ofNullable(this.link);
    }

    @Nonnull
    public String getPath() {
        return StringUtils.stripToEmpty((String)this.delegate.getInternalPath());
    }

    @Nonnull
    public String getReportKey() {
        return this.delegate.getReport().getKey();
    }

    @Nonnull
    public AnnotationSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public Optional<AnnotationType> getType() {
        return Optional.ofNullable(this.type);
    }

    @Nonnull
    public InternalInsightAnnotation initialize() {
        return this.initializeInternal();
    }

    private InternalInsightAnnotation initializeInternal() {
        this.link = UrlUtils.uncheckedCreateURI((String)this.delegate.getInternalLink());
        this.severity = AnnotationSeverity.fromId(this.delegate.getSeverityId()).orElseThrow(() -> new IllegalStateException("Invalid severity ID"));
        if (this.delegate.getTypeId() != null) {
            this.type = AnnotationType.fromId(this.delegate.getTypeId()).orElseThrow(() -> new IllegalArgumentException("Invalid type ID"));
        }
        return this.delegate;
    }
}

