/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightReport;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightAnnotationDao;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightReportDao;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightReport;
import com.atlassian.bitbucket.internal.codeinsights.dao.SetInsightReportParameters;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AoInsightReportDao
extends AbstractAoDao
implements InsightReportDao {
    private static final Logger log = LoggerFactory.getLogger(AoInsightReportDao.class);
    private final InsightAnnotationDao annotationDao;

    public AoInsightReportDao(ActiveObjects activeObjects, InsightAnnotationDao annotationDao) {
        super(activeObjects);
        this.annotationDao = annotationDao;
    }

    @Override
    @Nonnull
    public InternalInsightReport create(@Nonnull SetInsightReportParameters request) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("AUTHOR_ID", request.getAuthorId());
        properties.put("COMMIT_ID", request.getCommitId());
        properties.put("COVERAGE_PROVIDER_KEY", request.getCoverageProviderKey());
        properties.put("CREATED_DATE", request.getCreatedDate());
        properties.put("DATA", request.getData());
        properties.put("DETAILS", request.getDetails());
        properties.put("REPORT_KEY", request.getKey().toLowerCase(Locale.US));
        properties.put("LINK", request.getLink());
        properties.put("LOGO", request.getLogoUrl());
        properties.put("REPOSITORY_ID", request.getRepositoryId());
        properties.put("RESULT_ID", request.getResultId());
        properties.put("TITLE", request.getTitle());
        properties.put("REPORTER", request.getReporter());
        AoInsightReport report = (AoInsightReport)this.ao.create(AoInsightReport.class, properties);
        return (InternalInsightReport)this.ao.get(AoInsightReport.class, (Object)report.getID());
    }

    @Override
    public void delete(@Nonnull InternalInsightReport report) {
        this.annotationDao.deleteForReport(report.getID());
        this.ao.delete(new RawEntity[]{this.toAoInsightReport(report)});
    }

    @Override
    public int deleteById(Long ... reportIds) {
        if (reportIds.length == 0) {
            return 0;
        }
        this.annotationDao.deleteForReport(reportIds);
        return this.ao.deleteWithSQL(AoInsightReport.class, "ID IN (" + StringUtils.repeat((String)"?", (String)",", (int)reportIds.length) + ")", (Object[])reportIds);
    }

    @Override
    @Nonnull
    public Page<InternalInsightReport> find(int repositoryId, @Nonnull String commitId, @Nonnull Collection<String> reportKeys, @Nonnull PageRequest pageRequest) {
        Object whereClause = "REPOSITORY_ID = ? AND COMMIT_ID = ?";
        if (!reportKeys.isEmpty()) {
            whereClause = (String)whereClause + " AND REPORT_KEY IN (" + StringUtils.repeat((String)"?", (String)",", (int)reportKeys.size()) + ")";
        }
        return PageUtils.asPageOf(InternalInsightReport.class, (Page)this.pageQuery(AoInsightReport.class, Query.select().where((String)whereClause, Stream.concat(Stream.of(Integer.valueOf(repositoryId), commitId), reportKeys.stream().map(reportKey -> reportKey.toLowerCase(Locale.US))).toArray()).order("TITLE ASC"), pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalInsightReport> findCreatedBefore(@Nonnull Date date, @Nonnull PageRequest pageRequest) {
        return PageUtils.asPageOf(InternalInsightReport.class, (Page)this.pageQuery(AoInsightReport.class, Query.select().where("CREATED_DATE < ?", new Object[]{date}).order("CREATED_DATE DESC"), pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalInsightReport> findForRepository(int repoId, @Nonnull PageRequest pageRequest) {
        return PageUtils.asPageOf(InternalInsightReport.class, (Page)this.pageQuery(AoInsightReport.class, Query.select().where("REPOSITORY_ID = ?", new Object[]{repoId}).order("CREATED_DATE DESC"), pageRequest));
    }

    @Override
    @Nullable
    public InternalInsightReport get(int repositoryId, @Nonnull String commitId, @Nonnull String key) {
        return this.internalGet(repositoryId, commitId, key);
    }

    @Override
    public boolean reportExists(int repositoryId, @Nonnull String commitId, @Nonnull String key) {
        String whereClause = String.format("%s = ? AND %s = ? AND %s = ?", "REPOSITORY_ID", "COMMIT_ID", "REPORT_KEY");
        return this.ao.count(AoInsightReport.class, Query.select().where(whereClause, new Object[]{repositoryId, commitId, key.toLowerCase(Locale.US)})) > 0;
    }

    @Override
    @Nonnull
    public InternalInsightReport update(@Nonnull InternalInsightReport report, @Nonnull SetInsightReportParameters request) {
        AoInsightReport existing = (AoInsightReport)report;
        existing.setCoverageProviderKey(request.getCoverageProviderKey());
        existing.setData(request.getData());
        existing.setDetails(request.getDetails());
        existing.setLink(request.getLink());
        existing.setLogoUrl(request.getLogoUrl());
        existing.setResultId(request.getResultId());
        existing.setTitle(request.getTitle());
        existing.setReporter(request.getReporter());
        existing.save();
        return report;
    }

    private AoInsightReport[] getReports(int repositoryId, String commitId, String key) {
        String whereClause = String.format("%s = ? AND %s = ? AND %s = ?", "REPOSITORY_ID", "COMMIT_ID", "REPORT_KEY");
        return (AoInsightReport[])this.ao.find(AoInsightReport.class, Query.select().where(whereClause, new Object[]{repositoryId, commitId, key.toLowerCase(Locale.US)}).order("CREATED_DATE DESC"));
    }

    private AoInsightReport internalGet(int repositoryId, @Nonnull String commitId, @Nonnull String key) {
        AoInsightReport[] reports = this.getReports(repositoryId, commitId, key);
        if (reports.length > 1) {
            log.warn(String.format("Multiple reports found for key '%s' in repository %d with commit %s", key, repositoryId, commitId));
        }
        return reports.length == 0 ? null : reports[0];
    }

    private AoInsightReport toAoInsightReport(InternalInsightReport report) {
        return (AoInsightReport)AoInsightReport.class.cast(report);
    }
}

