/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportData;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.util.MoreCollectors;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=InsightReport.class)
public class RestInsightReport
extends RestMapEntity {
    static final String COVERAGE_PROVIDER_KEY = "coverageProviderKey";
    static final String CREATED_DATE = "createdDate";
    static final String DATA = "data";
    static final String DETAILS = "details";
    static final String KEY = "key";
    static final String LINK = "link";
    static final String LOGO_URL = "logoUrl";
    static final String REPORTER = "reporter";
    static final String RESULT = "result";
    static final String TITLE = "title";

    public RestInsightReport() {
    }

    RestInsightReport(Map<String, ?> values) {
        super(values);
    }

    public RestInsightReport(InsightReport report) {
        this(report.getData(), report.getCreatedDate().getTime(), report.getDetails().orElse(null), report.getKey(), report.getLink().map(URI::toASCIIString).orElse(null), report.getLogoUrl().map(URI::toASCIIString).orElse(null), report.getResult().map(Enum::toString).orElse(null), report.getTitle(), report.getReporter().orElse(null), report.getCoverageProviderKey().orElse(null));
    }

    RestInsightReport(List<InsightReportData> data, Long createdDate, String details, String key, String link, String logoUrl, String result, String title, String reporter, String coverageProviderKey) {
        this.putIfNotEmpty(DATA, this.toRestData(data));
        this.putIfNotNull(CREATED_DATE, createdDate);
        this.putIfNotNull(DETAILS, details);
        this.put(KEY, key);
        this.putIfNotNull(LINK, link);
        this.putIfNotNull(LOGO_URL, logoUrl);
        this.putIfNotNull(RESULT, result);
        this.put(TITLE, title);
        this.putIfNotNull(REPORTER, reporter);
        this.putIfNotNull(COVERAGE_PROVIDER_KEY, coverageProviderKey);
    }

    @Schema(example="1630041546433", type="number")
    @Nonnull
    public Date getCreatedDate() {
        return new Date(this.getLongProperty(CREATED_DATE));
    }

    @Nonnull
    public List<RestInsightReportData> getData() {
        Object object = this.get(DATA);
        if (object instanceof List) {
            List dataList = (List)object;
            return (List)dataList.stream().map(RestInsightReportData::valueOf).collect(MoreCollectors.toImmutableList());
        }
        return Collections.emptyList();
    }

    @Schema(example="This is the details of the report, it can be a longer string describing the report")
    @Nonnull
    public Optional<String> getDetails() {
        return Optional.ofNullable(this.getStringProperty(DETAILS));
    }

    @Schema(example="report.key")
    @Nonnull
    public String getKey() {
        return this.getStringProperty(KEY);
    }

    @Schema(example="http://integration.example.com")
    @Nonnull
    public Optional<URI> getLink() {
        return Optional.ofNullable(this.getStringProperty(LINK)).map(URI::create);
    }

    @Schema(example="http://integration.example.com/logo")
    @Nonnull
    public Optional<URI> getLogoUrl() {
        return Optional.ofNullable(this.getStringProperty(LOGO_URL)).map(URI::create);
    }

    @Schema(example="Reporter/tool that produced this report")
    @Nonnull
    public Optional<String> getReporter() {
        return Optional.ofNullable(this.getStringProperty(REPORTER));
    }

    @Schema(example="PASS")
    @Nonnull
    public Optional<InsightResult> getResult() {
        return Optional.ofNullable(this.getEnumProperty(RESULT, InsightResult.class));
    }

    @Schema(example="report.title")
    @Nonnull
    public String getTitle() {
        return this.getStringProperty(TITLE);
    }

    private List<RestInsightReportData> toRestData(List<InsightReportData> data) {
        return data == null ? null : (List)data.stream().map(RestInsightReportData::new).collect(MoreCollectors.toImmutableList());
    }
}

