/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.coverage.CodeCoverageService;
import com.atlassian.bitbucket.internal.codeinsights.rest.JsonCodeCoverageCallback;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.UnrestrictedAccess;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/coverage")
public class PullRequestCodeCoverageResource
extends RestResource {
    private final CodeCoverageService coverageService;

    public PullRequestCodeCoverageResource(CodeCoverageService coverageService, I18nService i18nService) {
        super(i18nService);
        this.coverageService = coverageService;
    }

    @GET
    @Path(value="{path:.*}")
    public Response getFileCoverage(final @Context PullRequest pullRequest, final @PathParam(value="path") String path, final @Context PageRequest pageRequest) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.codeinsights.coverage.path.required", new Object[0]));
        }
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                PullRequestCodeCoverageResource.this.coverageService.streamCoverage(pullRequest, path, new JsonCodeCoverageCallback(writer, pageRequest), pageRequest);
            }
        }).build();
    }

    @GET
    public Response getFileCoverage(@Context PullRequest pullRequest, @Context PageRequest pageRequest) {
        return this.getFileCoverage(pullRequest, null, pageRequest);
    }
}

