/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightReportCondition;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightMergeCheckSettingsDao;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InternalInsightReportCondition;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.stereotype.Component;

@Component
public class AoInsightMergeCheckSettingsDao
extends AbstractAoDao
implements InsightMergeCheckSettingsDao {
    public AoInsightMergeCheckSettingsDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public InternalInsightReportCondition create(int resourceId, @Nonnull ScopeType scopeType, @Nonnull String reportKey, @Nullable AnnotationSeverity minimumProhibited, boolean mustPass) {
        ImmutableMap.Builder data = ImmutableMap.builder().put((Object)"RESOURCE_ID", (Object)resourceId).put((Object)"SCOPE_TYPE", (Object)scopeType).put((Object)"REPORT_KEY", (Object)reportKey).put((Object)"MUST_PASS", (Object)mustPass);
        if (minimumProhibited != null) {
            data.put((Object)"ANNOTATION_SEVERITY", (Object)minimumProhibited);
        }
        return (InternalInsightReportCondition)this.ao.create(AoInsightReportCondition.class, (Map)data.build());
    }

    @Override
    public void delete(long id) {
        this.ao.delete(new RawEntity[]{this.ao.get(AoInsightReportCondition.class, (Object)id)});
    }

    @Override
    @Nonnull
    public Page<InternalInsightReportCondition> findForProject(int projectId, @Nonnull PageRequest request) {
        Object[] arguments = new Object[]{ScopeType.PROJECT, projectId};
        String whereClause = String.format("%s = ? AND %s = ?", "SCOPE_TYPE", "RESOURCE_ID");
        return PageUtils.asPageOf(InternalInsightReportCondition.class, (Page)this.pageQuery(AoInsightReportCondition.class, Query.select().where(whereClause, arguments).order("REPORT_KEY ASC"), request));
    }

    @Override
    @Nonnull
    public Page<InternalInsightReportCondition> findForRepository(int projectId, int repositoryId, @Nonnull PageRequest request) {
        Object[] arguments = new Object[]{ScopeType.PROJECT, projectId, ScopeType.REPOSITORY, repositoryId};
        String whereClause = String.format("( %s = ? AND %s = ? ) OR ( %s = ? AND %s = ? )", "SCOPE_TYPE", "RESOURCE_ID", "SCOPE_TYPE", "RESOURCE_ID");
        return PageUtils.asPageOf(InternalInsightReportCondition.class, (Page)this.pageQuery(AoInsightReportCondition.class, Query.select().where(whereClause, arguments).order("REPORT_KEY ASC"), request));
    }

    @Override
    @Nonnull
    public Optional<InternalInsightReportCondition> get(int resourceId, @Nonnull ScopeType scopeType, @Nonnull String reportKey) {
        return PageUtils.asPageOf(InternalInsightReportCondition.class, (Page)this.pageQuery(AoInsightReportCondition.class, Query.select().where("RESOURCE_ID= ? AND SCOPE_TYPE= ? AND REPORT_KEY= ?", new Object[]{resourceId, scopeType, reportKey}), PageUtils.newRequest((int)0, (int)1))).stream().findFirst();
    }
}

