/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.coverage;

import com.atlassian.bitbucket.codeinsights.coverage.CodeCoverageProviderModuleDescriptor;
import com.atlassian.bitbucket.codeinsights.coverage.CodeCoverageRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightReportService;
import com.atlassian.bitbucket.codeinsights.report.SearchInsightReportRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.annotation.PullRequestAnnotationHelper;
import com.atlassian.bitbucket.internal.codeinsights.annotation.SourceDiff;
import com.atlassian.bitbucket.internal.codeinsights.coverage.CodeCoverageService;
import com.atlassian.bitbucket.internal.codeinsights.coverage.InvalidPathException;
import com.atlassian.bitbucket.internal.codeinsights.rest.PagedCodeCoverageCallback;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="codeCoverageService")
public class DefaultCodeCoverageService
implements CodeCoverageService {
    private static final Timer CODE_INSIGHTS = Timers.timer((String)"CodeInsights");
    private final I18nService i18nService;
    private final InsightReportService insightReportService;
    private final PermissionValidationService permissionValidationService;
    private final PluginAccessor pluginAccessor;
    private final PullRequestAnnotationHelper pullRequestAnnotationHelper;

    @Autowired
    public DefaultCodeCoverageService(I18nService i18nService, InsightReportService insightReportService, PermissionValidationService permissionValidationService, PluginAccessor pluginAccessor, PullRequestAnnotationHelper pullRequestAnnotationHelper) {
        this.i18nService = i18nService;
        this.insightReportService = insightReportService;
        this.permissionValidationService = permissionValidationService;
        this.pluginAccessor = pluginAccessor;
        this.pullRequestAnnotationHelper = pullRequestAnnotationHelper;
    }

    private static CodeCoverageRequest createRequest(final String path, final PullRequest pullRequest, final String reportKey) {
        return new CodeCoverageRequest(){

            @Override
            @Nonnull
            public String getPath() {
                return path;
            }

            @Override
            @Nonnull
            public PullRequest getPullRequest() {
                return pullRequest;
            }

            @Override
            @Nonnull
            public String getReportKey() {
                return reportKey;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamCoverage(@Nonnull PullRequest pullRequest, @Nonnull String path, @Nonnull PagedCodeCoverageCallback callback, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateForRepository(pullRequest.getToRef().getRepository(), Permission.REPO_READ);
        Map moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CodeCoverageProviderModuleDescriptor.class).stream().collect(Collectors.toMap(ModuleDescriptor::getCompleteKey, Function.identity()));
        if (moduleDescriptors.isEmpty()) {
            callback.start();
            callback.end();
            return;
        }
        SourceDiff sourceDiff = this.pullRequestAnnotationHelper.getSourceDiff(pullRequest, (Set<String>)ImmutableSet.of((Object)path));
        this.validateFile(sourceDiff, path);
        try {
            callback.start();
            Page insightReports = PageUtils.filterPages(page -> this.insightReportService.search(new SearchInsightReportRequest.Builder(pullRequest).build(), page), report -> report.getCoverageProviderKey().isPresent() && moduleDescriptors.containsKey(report.getCoverageProviderKey().get()), (PageRequest)pageRequest);
            insightReports.stream().findFirst().ifPresent(insightReport -> {
                try (Ticker ignored = CODE_INSIGHTS.start(new Object[]{"stream coverage", insightReport.getCoverageProviderKey(), pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), path});){
                    ((CodeCoverageProviderModuleDescriptor)((Object)((Object)moduleDescriptors.get(insightReport.getCoverageProviderKey().get())))).getModule().streamCoverage(DefaultCodeCoverageService.createRequest(path, pullRequest, insightReport.getKey()), callback);
                }
            });
        }
        finally {
            callback.end();
        }
    }

    private void validateFile(SourceDiff sourceDiff, String path) {
        if (!sourceDiff.getFileChanges().containsKey(path)) {
            throw new InvalidPathException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.coverage.path.not.found", new Object[0]));
        }
    }
}

