/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.codeinsights.annotation.SingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsReportEvent;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightReport;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.codeinsights.annotations.created")
public class AnalyticsAnnotationsCreatedEvent
extends AnalyticsReportEvent {
    private static final String TYPE_UNSPECIFIED = "UNSPECIFIED";
    private final Map<String, Long> countsBySeverityAndType;

    public AnalyticsAnnotationsCreatedEvent(@Nonnull Repository repository, @Nonnull InternalInsightReport report, @Nonnull Collection<SingleAddInsightAnnotationRequest> annotations) {
        super(repository, report);
        this.countsBySeverityAndType = annotations.stream().collect(Collectors.groupingBy(this::getSeverityAndType, Collectors.counting()));
    }

    @Nonnull
    public Map<String, Long> getCounts() {
        return this.countsBySeverityAndType;
    }

    private String getSeverityAndType(SingleAddInsightAnnotationRequest annotation) {
        return annotation.getSeverity().name() + "." + (annotation.getType() == null ? TYPE_UNSPECIFIED : annotation.getType().name());
    }
}

