define('bitbucket-plugin-build/internal/feature/build/compare/build-status-compare', ['exports', 'jquery', 'bitbucket/internal/util/events', 'bitbucket/util/navbuilder', '../common/build-status-common'], function (exports, _jquery, _events, _navbuilder, _buildStatusCommon) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.registerPlaceholder = undefined;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _events2 = _interopRequireDefault(_events);

    var navbuilder = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Register a placeholder for a given revision selector type
     * @param {('source'|'target')} type
     */
    function registerPlaceholder(type) {
        var el = document.querySelector('#build-status-' + type + '-selector');
        showBuildStatusIcon((0, _buildStatusCommon.getQueryParam)(type + 'Branch'), type, el);

        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.repository.sourceTargetSelector.' + type + '.revisionRefChanged', function (revisionRef) {
            var ref = revisionRef.getId();
            el.dataset.ref = ref;
            showBuildStatusIcon(ref, type, el);
        });
    }

    /**
     * Show the build status icon inside the given container element
     * @param {string} buildRefId
     * @param {HTMLElement} containerEl
     */
    function showBuildStatusIcon(buildRefId, type, containerEl) {
        if (buildRefId) {
            var $containerEl = (0, _jquery2.default)(containerEl);
            $containerEl.empty();

            var repository = (0, _jquery2.default)('#' + type + 'Repo').find('.repository').data('repository');

            var link = navbuilder.repository(repository).builds().withParams({ at: buildRefId }).build();

            (0, _buildStatusCommon.getStatsByRefsAndRepo)([buildRefId], repository).done(function (stats) {
                var buildStats = stats[buildRefId];

                if (buildStats) {
                    var iconMarkup = bitbucketPluginBuild.internal.feature.build.common.buildStatusCommon.summaryIcon({
                        stats: buildStats,
                        link: link
                    });
                    $containerEl.html((0, _jquery2.default)(iconMarkup).tooltip({ gravity: 'w' }));
                }
            });
        }
    }

    exports.registerPlaceholder = registerPlaceholder;
});