define('bitbucket-plugin-build/internal/feature/build/branch-creation/build-status-branch-creation', ['exports', 'jquery', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/events', 'bitbucket/util/navbuilder', '../common/build-status-common'], function (exports, _jquery, _revisionReference, _events, _navbuilder, _buildStatusCommon) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _revisionReference2 = _interopRequireDefault(_revisionReference);

    var _events2 = _interopRequireDefault(_events);

    var navbuilder = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function onReady() {
        var $branchFromTrigger = (0, _jquery2.default)('#branch-from-selector');
        var revisionRefJson = $branchFromTrigger.find('.name').data('revision-ref');
        var revisionRef = revisionRefJson ? new _revisionReference2.default(revisionRefJson) : null;

        showBuildStatusIcon();

        function showBuildStatusIcon() {
            $branchFromTrigger.next('.build-icon').remove();
            if (revisionRef) {
                var repository = (0, _jquery2.default)('#repository-selector').find('.repository').data('repository');
                var link = navbuilder.repository(repository).builds().withParams({ at: revisionRef.getId() }).build();

                (0, _buildStatusCommon.getStatsByRefsAndRepo)([revisionRef.getId()], repository).done(function (stats) {
                    var branchStats = stats[revisionRef.getId()];

                    if (branchStats) {
                        (0, _jquery2.default)(bitbucketPluginBuild.internal.feature.build.common.buildStatusCommon.summaryIcon({
                            stats: branchStats,
                            link: link
                        })).insertAfter($branchFromTrigger).tooltip({
                            gravity: 'w'
                        });
                    }
                });
            }
        }

        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.repository.revisionReferenceSelector.revisionRefChanged', function (revisionReference) {
            revisionRef = revisionReference;
            showBuildStatusIcon();
        });
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.repository.revisionReferenceSelector.repoChanged', function () {
            $branchFromTrigger.next('.build-icon').remove();
            revisionRef = null;
        });
    }
});