/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.status.rest;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.function.Function;

@JsonSerialize
public class RestBuildStatus
extends RestMapEntity {
    public static final Function<LegacyBuildStatus, RestBuildStatus> REST_TRANSFORM = RestBuildStatus::new;
    private static final String DATE_ADDED = "dateAdded";
    private static final String DESCRIPTION = "description";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String STATE = "state";
    private static final String URL = "url";

    public RestBuildStatus() {
    }

    protected RestBuildStatus(LegacyBuildStatus buildStatus) {
        this(buildStatus.getState(), buildStatus.getKey(), buildStatus.getName(), buildStatus.getUrl(), buildStatus.getDescription(), buildStatus.getUpdatedDate());
    }

    protected RestBuildStatus(BuildState state, String key, String name, String url, String description, Date dateAdded) {
        this.put(STATE, state);
        this.put(KEY, key);
        this.put(NAME, name);
        this.put(URL, url);
        this.put(DESCRIPTION, description);
        if (dateAdded != null) {
            this.put(DATE_ADDED, dateAdded.getTime());
        }
    }

    @Schema(example="1630041546433")
    public long getDateAdded() {
        return this.getLongProperty(DATE_ADDED);
    }

    @Schema(example="Changes by John Doe")
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Schema(example="REPO-MASTER")
    public String getKey() {
        return this.getStringProperty(KEY);
    }

    @Schema(example="REPO-MASTER-42")
    public String getName() {
        return this.getStringProperty(NAME);
    }

    public BuildState getState() {
        return (BuildState)this.getEnumProperty(STATE, BuildState.class);
    }

    @Schema(example="https://bamboo.example.com/browse/REPO-MASTER-42")
    public String getUrl() {
        return this.getStringProperty(URL);
    }
}

