/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.status.rest;

import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatusService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.stash.internal.build.status.rest.RestBuildStats;
import com.atlassian.stash.internal.build.status.rest.RestBuildStatus;
import com.atlassian.stash.internal.build.status.rest.RestMultipleBuildStats;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@BasePathDoc(value="build-status/latest")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="commits")
@Singleton
@Tag(name="Deprecated")
public class BuildStatusResource {
    private static final int KEY_MAX_LEN = 255;
    private static final int NAME_MAX_LEN = 255;
    private static final int URL_MAX_LEN = 450;
    private static final Pattern COMMIT_ID_PATTERN = Pattern.compile("[a-fA-F0-9]{40}");
    private final LegacyBuildStatusService buildStatusService;
    private final I18nService i18nService;

    @Inject
    public BuildStatusResource(LegacyBuildStatusService buildStatusService, I18nService i18nService) {
        this.buildStatusService = buildStatusService;
        this.i18nService = i18nService;
    }

    @GET
    @Deprecated
    @Path(value="{commitId}")
    @Operation(description="Gets build statuses associated with a commit.\n\n<strong>Deprecated in 7.14, please use the repository based builds resource instead.</strong>", summary="Get build statuses for commit", deprecated=true)
    @Parameters(value={@Parameter(name="commitId", description="Full SHA1 of the commit (ex: <code>e00cf62997a027bbf785614a93e2e55bb331d268</code>)", in=ParameterIn.PATH), @Parameter(name="orderBy", description="How the results should be ordered. Options are NEWEST, OLDEST, STATUS", in=ParameterIn.QUERY, example="newest, oldest, or status")})
    @ResponseDocs(value={@ResponseDoc(documentation="A Page of build statuses associated with the commit <br /> (limited to the most recent 100 build statuses associated with the commit)", paged=true, representation=RestBuildStatus.class, responseCode=200), @ResponseDoc(documentation="The user is not authenticated or does not have the <b>LICENSED</b> permission.", responseCode=401, restError=true)})
    public Response getBuildStatus(@Parameter(hidden=true) @PathParam(value="commitId") String commitId, @BeanParam PageRequestResolver pageRequestResolver, @Parameter(hidden=true) @QueryParam(value="orderBy") @DefaultValue(value="newest") String orderBy) {
        BuildOrder order = (BuildOrder)BuildOrder.fromString((String)orderBy).orElseThrow(() -> new BadRequestException(this.i18nService.getMessage("bitbucket.rest.build.status.order.invalid", new Object[]{orderBy, Arrays.asList(BuildOrder.values())})));
        Page page = this.buildStatusService.findAll(commitId, pageRequestResolver.getPageRequest(), order);
        return ResponseFactory.ok((Object)new RestPage(page, RestBuildStatus.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="stats/{commitId}")
    @Operation(description="Gets statistics regarding the builds associated with a commit", summary="Get build status statistics for commit")
    @Parameters(value={@Parameter(name="commitId", description="full SHA1 of the commit", example="e00cf62997a027bbf785614a93e2e55bb331d268", in=ParameterIn.PATH), @Parameter(name="includeUnique", description="include a unique build result if there is either only one failed build, only one in-progress build or only one successful build", schema=@Schema(type="boolean"), in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The number of successful/failed/in-progress/cancelled/unknown builds for the commit", representation=RestBuildStats.class, responseCode=200), @ResponseDoc(documentation="The user is not authenticated or does not have the <b>LICENSED</b> permission.", responseCode=401, restError=true)})
    @Tag(name="Builds and Deployments")
    public Response getBuildStatusStats(@PathParam(value="commitId") String commitId, @QueryParam(value="includeUnique") @DefaultValue(value="false") boolean includeUnique) {
        BuildSummary stats = this.buildStatusService.getSummary(commitId);
        RestBuildStats restStats = new RestBuildStats(stats);
        if (includeUnique) {
            this.includeUniqueResult(restStats, commitId, stats);
        }
        return ResponseFactory.ok((Object)((Object)restStats)).build();
    }

    protected void includeUniqueResult(RestBuildStats restStats, String commitId, BuildSummary stats) {
        BuildState state = null;
        int failedCount = stats.getFailedCount();
        if (failedCount > 0) {
            if (failedCount == 1) {
                state = BuildState.FAILED;
            }
        } else {
            int inProgressCount = stats.getInProgressCount();
            if (inProgressCount > 0) {
                if (inProgressCount == 1) {
                    state = BuildState.INPROGRESS;
                }
            } else {
                int successfulCount = stats.getSuccessfulCount();
                if (successfulCount == 1) {
                    state = BuildState.SUCCESSFUL;
                }
            }
        }
        if (state != null) {
            restStats.include(this.firstMatching(commitId, state));
        }
    }

    private LegacyBuildStatus firstMatching(String commitId, BuildState state) {
        return (LegacyBuildStatus)Iterables.find((Iterable)this.buildStatusService.findAll(commitId).getValues(), build -> build.getState() == state, null);
    }

    @POST
    @Path(value="stats")
    @Operation(description="Produces a list of the build statistics for multiple commits. Commits <em>without any builds associated with them</em> will not be returned.<br> For example if the commit <code>e00cf62997a027bbf785614a93e2e55bb331d268</code> does not have any build statuses associated with it, it will not be present in the response.", summary="Get build status statistics for multiple commits")
    @ResponseDocs(value={@ResponseDoc(documentation="The number of successful/failed/in-progress/cancelled/unknown builds for each commit (with the caveat that the commits <em>without any builds associated with them</em> will not be present in the response)", representation=RestMultipleBuildStats.class, responseCode=200), @ResponseDoc(documentation="The user is not authenticated or does not have the <strong>LICENSED</strong> permission", responseCode=401, restError=true)})
    @RequestBody(description="full SHA1 of each commit", content={@Content(array=@ArraySchema(schema=@Schema(example="db0dd118fa6ccdf1d593fef00df839dd27702df7", type="string")))})
    @Tag(name="Builds and Deployments")
    public Response getMultipleBuildStatusStats(List<String> commitIds) {
        Map stats = this.buildStatusService.getSummaries(commitIds);
        return ResponseFactory.ok((Object)((Object)new RestMultipleBuildStats(stats))).build();
    }

    @POST
    @Deprecated
    @Path(value="{commitId}")
    @EscalateAnonymous2LO(value={Permission.LICENSED_USER})
    @Operation(description="Associates a build status with a commit.The <code>state</code>, the <code>key</code> and the <code>url</code> fields are mandatory. The <code>name</code> and<code>description</code> fields are optional.All fields (mandatory or optional) are limited to 255 characters, except for the <code>url</code>,which is limited to 450 characters.Supported values for the <code>state</code> are <code>SUCCESSFUL</code>, <code>FAILED</code>and <code>INPROGRESS</code>.The authenticated user must have <strong>LICENSED</strong> permission or higher to call this resource.\n\n<strong>Deprecated in 7.14, please use the repository based builds resource instead.</strong>", summary="Create build status for commit", deprecated=true)
    @Parameter(name="commitId", description="full SHA1 of the commit", example="e00cf62997a027bbf785614a93e2e55bb331d268", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response if the build status was successfully stored", responseCode=204), @ResponseDoc(documentation="An error message if the <code>commitId</code> is not a full 40-characters SHA1, if the build status has a missing mandatory field or if the fields are too large", responseCode=400, restError=true), @ResponseDoc(documentation="The user is not authenticated or does not have the <strong>LICENSED</strong> permission", responseCode=401, restError=true)})
    @RequestBody(description="build status to associate with the commit", content={@Content(schema=@Schema(implementation=RestBuildStatus.class))})
    public Response addBuildStatus(@PathParam(value="commitId") String commitId, RestBuildStatus status) {
        this.validateCommitId(commitId);
        this.validate(status);
        this.buildStatusService.set(new BuildStatusSetRequest.Builder(commitId).dateAdded(status.getDateAdded()).description(status.getDescription()).key(status.getKey()).name(status.getName()).state(status.getState()).url(status.getUrl()).build());
        return ResponseFactory.noContent().build();
    }

    private void validateCommitId(String commitId) {
        if (!COMMIT_ID_PATTERN.matcher(commitId).matches()) {
            String message = this.i18nService.getMessage("bitbucket.build.status.commit.idinvalid", new Object[0]);
            throw new BadRequestException(message);
        }
    }

    private void validate(RestBuildStatus status) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.hasValidState(status)) {
            errors.add(this.i18nService.getMessage("bitbucket.rest.build.status.state.required", new Object[]{ArrayUtils.toString((Object)BuildState.values())}));
        }
        if (StringUtils.isBlank((CharSequence)status.getKey())) {
            errors.add(this.i18nService.getMessage("bitbucket.rest.build.status.key.required", new Object[0]));
        }
        if (StringUtils.length((CharSequence)status.getKey()) > 255) {
            errors.add(this.i18nService.getMessage("bitbucket.rest.build.status.key.oversized", new Object[]{255}));
        }
        if (StringUtils.length((CharSequence)status.getName()) > 255) {
            errors.add(this.i18nService.getMessage("bitbucket.rest.build.status.name.oversized", new Object[]{255}));
        }
        if (!this.isValidUrl(status.getUrl())) {
            errors.add(this.i18nService.getMessage("bitbucket.rest.build.status.url.required", new Object[0]));
        }
        if (StringUtils.length((CharSequence)status.getUrl()) > 450) {
            errors.add(this.i18nService.getMessage("bitbucket.rest.build.status.url.oversized", new Object[]{450}));
        }
        if (!errors.isEmpty()) {
            throw new BadRequestException(errors);
        }
    }

    private boolean hasValidState(RestBuildStatus status) {
        try {
            BuildState state = status.getState();
            return state != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidUrl(String url) {
        if (url == null) {
            return false;
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

