/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.rest;

import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class RestRequiredBuildConditionSetRequest
extends RestMapEntity {
    private static final String BUILD_PARENT_KEYS = "buildParentKeys";
    private static final String EXEMPT_REF_MATCHER = "exemptRefMatcher";
    private static final String REF_MATCHER = "refMatcher";

    public RestRequiredBuildConditionSetRequest() {
    }

    private RestRequiredBuildConditionSetRequest(Map<String, Object> values) {
        super(values);
    }

    RestRequiredBuildConditionSetRequest(Collection<String> buildParentKeys, RestRefMatcher refMatcher, RestRefMatcher exemptRefMatcher) {
        this.put(BUILD_PARENT_KEYS, new ArrayList<String>(buildParentKeys));
        this.put(REF_MATCHER, refMatcher);
        this.putIfNotNull(EXEMPT_REF_MATCHER, exemptRefMatcher);
    }

    @NotNull(message="{bitbucket.rest.build.requiredbuilds.error.build.keys.required}")
    @ArraySchema(arraySchema=@Schema(description="A non-empty list of build parent keys that require green builds for this merge check to pass", example="[\"build-key-1\", \"build-key-2\"]"))
    @Size(max=100, message="{bitbucket.rest.build.requiredbuilds.error.build.keys.toomany}")
    public @NotNull(message="{bitbucket.rest.build.requiredbuilds.error.build.keys.required}") @Size(max=100, message="{bitbucket.rest.build.requiredbuilds.error.build.keys.toomany}") List<String> getBuildParentKeys() {
        Object buildParentKeys = this.get(BUILD_PARENT_KEYS);
        if (buildParentKeys instanceof List && !((List)buildParentKeys).isEmpty()) {
            return (List)buildParentKeys;
        }
        return null;
    }

    @Nullable
    public RestRefMatcher getExemptRefMatcher() {
        return RestRefMatcher.valueOf((Object)this.get(EXEMPT_REF_MATCHER));
    }

    @NotNull(message="{bitbucket.rest.build.requiredbuilds.error.matcher.required}")
    public @NotNull(message="{bitbucket.rest.build.requiredbuilds.error.matcher.required}") RestRefMatcher getRefMatcher() {
        return RestRefMatcher.valueOf((Object)this.get(REF_MATCHER));
    }
}

