/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.rest;

import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.build.requiredbuilds.RefMatcherResolver;
import com.atlassian.stash.internal.build.requiredbuilds.RequiredBuildConditionSetRequest;
import com.atlassian.stash.internal.build.requiredbuilds.RequiredBuildsService;
import com.atlassian.stash.internal.build.requiredbuilds.model.RequiredBuildCondition;
import com.atlassian.stash.internal.build.requiredbuilds.rest.RestRequiredBuildCondition;
import com.atlassian.stash.internal.build.requiredbuilds.rest.RestRequiredBuildConditionSetRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Validator;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@LicensedOnly
@BasePathDoc(value="required-builds/latest")
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project that the repository belongs to"), @PathParamDoc(name="repositorySlug", documentation="The repository being used")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Builds and Deployments")
public class RequiredBuildsResource {
    private final RefMatcherResolver refMatcherResolver;
    private final RequiredBuildsService requiredBuildsService;
    private final Validator validator;

    @Inject
    public RequiredBuildsResource(RefMatcherResolver refMatcherResolver, RequiredBuildsService requiredBuildsService, Validator validator) {
        this.refMatcherResolver = refMatcherResolver;
        this.requiredBuildsService = requiredBuildsService;
        this.validator = validator;
    }

    @POST
    @Path(value="condition")
    @Operation(description="Create a required build merge check for the given repository.\n\nThe authenticated user must have **REPO_ADMIN** permission for the target repository to register a required build merge check.\n\nThe contents of the required build merge check request are:\n\nThese fields are **required**:\n\n- **buildParentKeys**: A non-empty list of build parent keys that require green builds for this merge check to pass\n- **refMatcher.id**: The value to match refs against in the target branch\n- **refMatcher.type.id**: The type of ref matcher, one of: \"ANY_REF\", \"BRANCH\", \"PATTERN\", \"MODEL_CATEGORY\" or \"MODEL_BRANCH\"\n\n\nThese fields are optional:\n\n- **exemptRefMatcher.id** The value to exempt refs in the source branch from this check\n- **exemptRefMatcher.type.id**: The type of exempt ref matcher, one of: \"ANY_REF\", \"BRANCH\", \"PATTERN\", \"MODEL_CATEGORY\" or \"MODEL_BRANCH\"\n\n\n", summary="Create a required builds merge check")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the newly created required build merge check.", representation=RestRequiredBuildCondition.class, responseCode=200), @ResponseDoc(documentation="The request was malformed. This could be caused because:\n\n- The build parent key list is empty\n- Either of the provided ref matchers is of an unrecognized type\n- Either of the provided ref matchers could not be created with the provided type and id\n\n\n", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a required build merge check in this repository.", responseCode=401, restError=true)})
    @RequestBody(description="The request specifying the required build parent keys, ref matcher and exemption matcher", content={@Content(schema=@Schema(implementation=RestRequiredBuildConditionSetRequest.class))})
    public Response createRequiredBuildsMergeCheck(@BeanParam ScopeResolver scopeResolver, RestRequiredBuildConditionSetRequest restSetRequest) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)restSetRequest), (Class[])new Class[0]);
        RequiredBuildCondition createdCheck = this.requiredBuildsService.createCondition(scopeResolver.getScope(), this.convertSetRequest(restSetRequest, scopeResolver.getScope()));
        return Response.ok((Object)((Object)new RestRequiredBuildCondition(createdCheck))).build();
    }

    @DELETE
    @Path(value="condition/{id}")
    @Operation(description="Deletes a required build existing merge check, given it's ID.\n\nThe authenticated user must have **REPO_ADMIN** permission for the target repository to delete a required build merge check.", summary="Delete a required builds merge check")
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating the merge check was successfully deleted, or was never present.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete a required build merge check in this repository.", responseCode=401, restError=true)})
    public Response deleteRequiredBuildsMergeCheck(@BeanParam ScopeResolver scopeResolver, @PathParam(value="id") long mergeCheckId) {
        this.requiredBuildsService.deleteCondition(scopeResolver.getScope(), mergeCheckId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="conditions")
    @Operation(description="Returns a page of required build merge checks that have been configured for this repository.\n\nThe authenticated user must have **REPO_READ** permission for the target repository to request a page of required build merge checks.", summary="Get required builds merge checks")
    @ResponseDocs(value={@ResponseDoc(documentation="The required build merge checks associated with the provided repository.", paged=true, representation=RestRequiredBuildCondition.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to request a page of required build merge checks in this repository.", responseCode=401, restError=true)})
    public Response getPageOfRequiredBuildsMergeChecks(@BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page result = this.requiredBuildsService.getConditions(scopeResolver.getScope(), pageRequestResolver.getPageRequest()).transform(RestRequiredBuildCondition::new);
        return Response.ok((Object)new RestPage(result)).build();
    }

    @PUT
    @Path(value="condition/{id}")
    @Operation(description="Update the required builds merge check for the given ID.\n\nThe authenticated user must have **REPO_ADMIN** permission for the target repository to update a required build merge check.\n\nThe contents of the required build merge check request are:\n\nThese fields are **required**:\n\n- **buildParentKeys**: A non-empty list of build parent keys that require green builds for this merge check to pass\n- **refMatcher.id**: The value to match refs against in the target branch\n- **refMatcher.type.id**: The type of ref matcher, one of: \"ANY_REF\", \"BRANCH\", \"PATTERN\", \"MODEL_CATEGORY\" or \"MODEL_BRANCH\"\n\n\nThese fields are optional:\n\n- **exemptRefMatcher.id** The value to exempt refs in the source branch from this check\n- **exemptRefMatcher.type.id**: The type of exempt ref matcher, one of: \"ANY_REF\", \"BRANCH\", \"PATTERN\", \"MODEL_CATEGORY\" or \"MODEL_BRANCH\"\n\n\n", summary="Update a required builds merge check")
    @ResponseDocs(value={@ResponseDoc(documentation="The details needed to update a required build merge check.", representation=RestRequiredBuildCondition.class, responseCode=200), @ResponseDoc(documentation="The request was malformed. This could be caused because:\n\n- The build parent key list is empty\n- Either of the provided ref matchers is of an unrecognized type\n- Either of the provided ref matchers could not be created with the provided type and id\n\n\n", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a required build merge check in this repository.", responseCode=401, restError=true)})
    @RequestBody(description="The request specifying the required build parent keys, ref matcher and exemption matcher", content={@Content(schema=@Schema(implementation=RestRequiredBuildConditionSetRequest.class))})
    public Response updateRequiredBuildsMergeCheck(@BeanParam ScopeResolver scopeResolver, @PathParam(value="id") long mergeCheckId, RestRequiredBuildConditionSetRequest restSetRequest) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)restSetRequest), (Class[])new Class[0]);
        RequiredBuildCondition updatedCheck = this.requiredBuildsService.updateCondition(scopeResolver.getScope(), mergeCheckId, this.convertSetRequest(restSetRequest, scopeResolver.getScope()));
        return Response.ok((Object)((Object)new RestRequiredBuildCondition(updatedCheck))).build();
    }

    private RequiredBuildConditionSetRequest convertSetRequest(RestRequiredBuildConditionSetRequest request, Scope scope) {
        RequiredBuildConditionSetRequest.Builder builder = new RequiredBuildConditionSetRequest.Builder(new HashSet<String>(request.getBuildParentKeys()), this.refMatcherResolver.resolve(request.getRefMatcher(), scope));
        if (request.getExemptRefMatcher() != null) {
            builder.exemptRefMatcher(this.refMatcherResolver.resolve(request.getExemptRefMatcher(), scope));
        }
        return builder.build();
    }
}

