/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildConditionCreatedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildConditionDeletedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildConditionEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildConditionUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequiredBuildConditionEventListener {
    @VisibleForTesting
    static final String ACTION_PROJECT_REQUIRED_BUILD_CONDITION_CREATED = "bitbucket.build.required.audit.action.project.condition.created";
    @VisibleForTesting
    static final String ACTION_PROJECT_REQUIRED_BUILD_CONDITION_DELETED = "bitbucket.build.required.audit.action.project.condition.deleted";
    @VisibleForTesting
    static final String ACTION_PROJECT_REQUIRED_BUILD_CONDITION_UPDATED = "bitbucket.build.required.audit.action.project.condition.updated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_REQUIRED_BUILD_CONDITION_CREATED = "bitbucket.build.required.audit.action.repository.condition.created";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_REQUIRED_BUILD_CONDITION_DELETED = "bitbucket.build.required.audit.action.repository.condition.deleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_REQUIRED_BUILD_CONDITION_UPDATED = "bitbucket.build.required.audit.action.repository.condition.updated";
    @VisibleForTesting
    static final String ATTR_BUILD_PARENT_KEYS = "bitbucket.build.required.audit.attribute.condition.buildparentkeys";
    @VisibleForTesting
    static final String ATTR_EXEMPT_REF_MATCHER = "bitbucket.build.required.audit.attribute.condition.exemptmatcher";
    @VisibleForTesting
    static final String ATTR_EXEMPT_REF_MATCHER_TYPE = "bitbucket.build.required.audit.attribute.condition.exemptmatcher.type";
    @VisibleForTesting
    static final String ATTR_REF_MATCHER = "bitbucket.build.required.audit.attribute.condition.matcher";
    @VisibleForTesting
    static final String ATTR_REF_MATCHER_TYPE = "bitbucket.build.required.audit.attribute.condition.matcher.type";
    private static final Map<Class<? extends RequiredBuildConditionEvent>, ScopeVisitor<AuditEvent.Builder>> AUDIT_EVENT_SCOPE_VISITOR = ImmutableMap.of(RequiredBuildConditionCreatedEvent.class, RequiredBuildConditionEventListener.getScopeVisitor("bitbucket.build.required.audit.action.project.condition.created", "bitbucket.build.required.audit.action.repository.condition.created"), RequiredBuildConditionDeletedEvent.class, RequiredBuildConditionEventListener.getScopeVisitor("bitbucket.build.required.audit.action.project.condition.deleted", "bitbucket.build.required.audit.action.repository.condition.deleted"), RequiredBuildConditionUpdatedEvent.class, RequiredBuildConditionEventListener.getScopeVisitor("bitbucket.build.required.audit.action.project.condition.updated", "bitbucket.build.required.audit.action.repository.condition.updated"));
    private final AuditService auditService;

    @Autowired
    public RequiredBuildConditionEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onRequiredBuildConditionCreatedEvent(RequiredBuildConditionCreatedEvent event) {
        this.auditRequiredBuildConditionEvent(event);
    }

    @EventListener
    public void onRequiredBuildConditionDeletedEvent(RequiredBuildConditionDeletedEvent event) {
        this.auditRequiredBuildConditionEvent(event);
    }

    @EventListener
    public void onRequiredBuildConditionUpdatedEvent(RequiredBuildConditionUpdatedEvent event) {
        this.auditRequiredBuildConditionEvent(event);
    }

    private static ScopeVisitor<AuditEvent.Builder> getScopeVisitor(final String projectAction, final String repositoryAction) {
        return new ScopeVisitor<AuditEvent.Builder>(){

            public AuditEvent.Builder visit(@Nonnull ProjectScope projectScope) {
                return AuditEvent.builder((AuditType)this.getAuditType(projectAction, "bitbucket.service.audit.category.projects").build()).affectedObject(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
            }

            public AuditEvent.Builder visit(@Nonnull RepositoryScope repositoryScope) {
                return AuditEvent.builder((AuditType)this.getAuditType(repositoryAction, "bitbucket.service.audit.category.repositories").build()).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository()));
            }

            private AuditType.Builder getAuditType(String action, String category) {
                return AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)category, (String)action);
            }
        };
    }

    private void addChangedValues(RequiredBuildConditionUpdatedEvent event, AuditEvent.Builder builder) {
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_BUILD_PARENT_KEYS).from(String.join((CharSequence)", ", event.getOldBuildParentKeys())).to(String.join((CharSequence)", ", event.getBuildParentKeys())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_REF_MATCHER).from(event.getOldRefMatcher().getDisplayId()).to(event.getRefMatcher().getDisplayId()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_REF_MATCHER_TYPE).from(event.getOldRefMatcher().getType().getDisplayId()).to(event.getRefMatcher().getType().getDisplayId()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_EXEMPT_REF_MATCHER).from((String)event.getOldExemptRefMatcher().map(RefMatcher::getDisplayId).orElse(null)).to((String)event.getExemptRefMatcher().map(RefMatcher::getDisplayId).orElse(null)).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_EXEMPT_REF_MATCHER_TYPE).from((String)event.getOldExemptRefMatcher().map(r -> r.getType().getDisplayId()).orElse(null)).to((String)event.getExemptRefMatcher().map(r -> r.getType().getDisplayId()).orElse(null)).build());
    }

    private void addExtraAttributes(RequiredBuildConditionEvent event, AuditEvent.Builder builder) {
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_BUILD_PARENT_KEYS, (String)String.join((CharSequence)", ", event.getBuildParentKeys())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REF_MATCHER, (String)event.getRefMatcher().getDisplayId()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REF_MATCHER_TYPE, (String)event.getRefMatcher().getType().getDisplayId()).build());
        event.getExemptRefMatcher().ifPresent(exemptMatcher -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EXEMPT_REF_MATCHER, (String)exemptMatcher.getDisplayId()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EXEMPT_REF_MATCHER_TYPE, (String)exemptMatcher.getType().getDisplayId()).build()));
    }

    private void auditRequiredBuildConditionEvent(RequiredBuildConditionEvent event) {
        AuditEvent.Builder builder = (AuditEvent.Builder)event.getScope().accept(AUDIT_EVENT_SCOPE_VISITOR.get(((Object)((Object)event)).getClass()));
        if (event instanceof RequiredBuildConditionUpdatedEvent) {
            this.addChangedValues((RequiredBuildConditionUpdatedEvent)event, builder);
        } else {
            this.addExtraAttributes(event, builder);
        }
        this.auditService.audit(builder.build());
    }
}

