/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds;

import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.util.MoreCollectors;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class RequiredBuildConditionSetRequest {
    private final Set<String> buildParentKeys;
    private final RefMatcher exemptRefMatcher;
    private final RefMatcher refMatcher;

    public RequiredBuildConditionSetRequest(Builder builder) {
        this.buildParentKeys = builder.buildParentKeys;
        this.exemptRefMatcher = builder.exemptRefMatcher;
        this.refMatcher = builder.refMatcher;
    }

    public Set<String> getBuildParentKeys() {
        return this.buildParentKeys;
    }

    public Optional<RefMatcher> getExemptRefMatcher() {
        return Optional.ofNullable(this.exemptRefMatcher);
    }

    public RefMatcher getRefMatcher() {
        return this.refMatcher;
    }

    public static class Builder {
        private final Set<String> buildParentKeys;
        private RefMatcher exemptRefMatcher;
        private final RefMatcher refMatcher;

        public Builder(@Nonnull Set<String> buildParentKeys, @Nonnull RefMatcher refMatcher) {
            this.buildParentKeys = (Set)Objects.requireNonNull(buildParentKeys, "buildParentKeys").stream().map(StringUtils::trimToNull).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
            this.refMatcher = Objects.requireNonNull(refMatcher, "refMatcherType");
        }

        public RequiredBuildConditionSetRequest build() {
            return new RequiredBuildConditionSetRequest(this);
        }

        public Builder exemptRefMatcher(@Nonnull RefMatcher exemptRefMatcher) {
            this.exemptRefMatcher = Objects.requireNonNull(exemptRefMatcher, "exemptRefMatcher");
            return this;
        }
    }
}

