/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.build.requiredbuilds.RefMatcherResolver;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class DefaultRefMatcherResolver
implements RefMatcherResolver {
    private final I18nService i18nService;
    private final RefMatcherProviderRegistry refMatcherProviderRegistry;

    public DefaultRefMatcherResolver(I18nService i18nService, RefMatcherProviderRegistry refMatcherProviderRegistry) {
        this.i18nService = i18nService;
        this.refMatcherProviderRegistry = refMatcherProviderRegistry;
    }

    @Override
    public RefMatcher resolve(@Nonnull String refMatcherType, @Nonnull String refMatcherValue, @Nonnull Scope scope) {
        RefMatcherProvider provider = this.refMatcherProviderRegistry.getProvider(refMatcherType);
        if (provider == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.requiredbuilds.error.invalid.provider", new Object[]{refMatcherType}));
        }
        return (RefMatcher)provider.create(scope, refMatcherValue).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.requiredbuilds.error.cannot.create.provider", new Object[]{refMatcherType, scope})));
    }

    @Override
    public RefMatcher resolve(@Nonnull RestRefMatcher restRefMatcher, @Nonnull Scope scope) {
        return this.resolve(restRefMatcher.getType().getId(), restRefMatcher.getId(), scope);
    }
}

