/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.minimumbuilds;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.setting.SettingsValidationErrors;
import com.atlassian.bitbucket.setting.SettingsValidator;
import javax.annotation.Nonnull;

public class MinimumBuildsValidator
implements SettingsValidator {
    private final I18nService i18nService;

    public MinimumBuildsValidator(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public void validate(@Nonnull Settings settings, @Nonnull SettingsValidationErrors errors, @Nonnull Scope scope) {
        Integer requiredBuilds;
        try {
            requiredBuilds = settings.getInt("requiredCount");
        }
        catch (NumberFormatException e) {
            errors.addFieldError("requiredCount", this.i18nService.getMessage("bitbucket.build.required.count.notanumber", new Object[0]));
            return;
        }
        if (requiredBuilds == null) {
            errors.addFieldError("requiredCount", this.i18nService.getMessage("bitbucket.build.required.count.notprovided", new Object[0]));
        } else if (requiredBuilds < 1) {
            errors.addFieldError("requiredCount", this.i18nService.getMessage("bitbucket.build.required.count.greaterthanzero", new Object[0]));
        }
    }
}

