/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.minimumbuilds;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.stash.internal.build.minimumbuilds.MinimumBuildsHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="minimumBuildsUpgradeTask")
public class MinimumBuildsUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MinimumBuildsUpgradeTask.class);
    private final PluginSettings pluginSettings;
    private final RepositoryService repositoryService;
    private final MinimumBuildsHelper minimumBuildsHelper;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;

    public MinimumBuildsUpgradeTask(PluginSettingsFactory pluginSettingsFactory, RepositoryService repositoryService, MinimumBuildsHelper minimumBuildsHelper, SecurityService securityService, TransactionTemplate transactionTemplate) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("com.atlassian.bitbucket.server.bitbucket-build");
        this.repositoryService = repositoryService;
        this.minimumBuildsHelper = minimumBuildsHelper;
        this.securityService = securityService;
        this.transactionTemplate = transactionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> doUpgrade() throws Exception {
        EscalatedSecurityContext withRepoAdmin = this.securityService.withPermission(Permission.REPO_ADMIN, this.getClass().getName());
        ExecutorService executor = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)(this.getClass().getSimpleName() + ".doUpgrade")));
        Future<Integer> future = executor.submit(() -> (Integer)withRepoAdmin.call(this::migrateConfig));
        try {
            int enabled = future.get();
            log.info("Enabled required builds hook for {} repositories", (Object)enabled);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
        }
        finally {
            ExecutorUtils.shutdown((ExecutorService)executor, (long)250L, (TimeUnit)TimeUnit.MILLISECONDS, (long)2L, (TimeUnit)TimeUnit.SECONDS, (Logger)log);
        }
        return Collections.emptyList();
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Move all the required builds settings from plugin-settings to hook-settings";
    }

    public String getPluginKey() {
        return "com.atlassian.bitbucket.server.bitbucket-build";
    }

    @VisibleForTesting
    protected static String createKey(int repoId) {
        return "repo." + repoId + ".requiredBuildsCount";
    }

    private int getCount(Repository repository) {
        Object value = this.pluginSettings.get(MinimumBuildsUpgradeTask.createKey(repository.getId()));
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warn("Required builds: Invalid plugin settings ''{}'' found for repository ''{}''", value, (Object)repository.getId());
            }
        }
        return 0;
    }

    private int migrateConfig() {
        int enabled = 0;
        int start = 0;
        while (start != -1) {
            ArrayList repositoryIds = new ArrayList(100);
            PageRequest pageRequest = PageUtils.newRequest((int)start, (int)100);
            start = (Integer)this.transactionTemplate.execute(() -> {
                Page page = this.repositoryService.findAll(pageRequest);
                page.stream().forEach(repository -> {
                    int count = this.getCount((Repository)repository);
                    if (count > 0) {
                        log.debug("{}: Enabling hook with {} builds required", repository, (Object)count);
                        this.minimumBuildsHelper.saveCount((Repository)repository, count);
                        repositoryIds.add(repository.getId());
                    }
                });
                PageRequest nextRequest = page.getNextPageRequest();
                return nextRequest == null ? -1 : nextRequest.getStart();
            });
            if (repositoryIds.size() > 0) {
                enabled += repositoryIds.size();
                repositoryIds.forEach(repoId -> this.pluginSettings.remove(MinimumBuildsUpgradeTask.createKey(repoId)));
                log.debug("Removed migrated settings for {} required builds hook", (Object)repositoryIds.size());
            }
            if (start % 1000 != 0) continue;
            log.info("Migrated required builds for {} repositories", (Object)start);
        }
        return enabled;
    }
}

